// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The logs.
 */
@Fluent
public final class LogsInner implements JsonSerializable<LogsInner> {
    /*
     * The content of the log.
     */
    private String content;

    /**
     * Creates an instance of LogsInner class.
     */
    public LogsInner() {
    }

    /**
     * Get the content property: The content of the log.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of the log.
     * 
     * @param content the content value to set.
     * @return the LogsInner object itself.
     */
    public LogsInner withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogsInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the LogsInner.
     */
    public static LogsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogsInner deserializedLogsInner = new LogsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    deserializedLogsInner.content = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogsInner;
        });
    }
}
