// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The regional capabilities.
 */
@Immutable
public final class Capabilities implements JsonSerializable<Capabilities> {
    /*
     * The resource type that this capability describes.
     */
    private String resourceType;

    /*
     * The OS type that this capability describes.
     */
    private String osType;

    /*
     * The resource location.
     */
    private String location;

    /*
     * The ip address type that this capability describes.
     */
    private String ipAddressType;

    /*
     * The GPU sku that this capability describes.
     */
    private String gpu;

    /*
     * The supported capabilities.
     */
    private CapabilitiesCapabilities capabilities;

    /**
     * Creates an instance of Capabilities class.
     */
    public Capabilities() {
    }

    /**
     * Get the resourceType property: The resource type that this capability describes.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the osType property: The OS type that this capability describes.
     * 
     * @return the osType value.
     */
    public String osType() {
        return this.osType;
    }

    /**
     * Get the location property: The resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the ipAddressType property: The ip address type that this capability describes.
     * 
     * @return the ipAddressType value.
     */
    public String ipAddressType() {
        return this.ipAddressType;
    }

    /**
     * Get the gpu property: The GPU sku that this capability describes.
     * 
     * @return the gpu value.
     */
    public String gpu() {
        return this.gpu;
    }

    /**
     * Get the capabilities property: The supported capabilities.
     * 
     * @return the capabilities value.
     */
    public CapabilitiesCapabilities capabilities() {
        return this.capabilities;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Capabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Capabilities if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Capabilities.
     */
    public static Capabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Capabilities deserializedCapabilities = new Capabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceType".equals(fieldName)) {
                    deserializedCapabilities.resourceType = reader.getString();
                } else if ("osType".equals(fieldName)) {
                    deserializedCapabilities.osType = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedCapabilities.location = reader.getString();
                } else if ("ipAddressType".equals(fieldName)) {
                    deserializedCapabilities.ipAddressType = reader.getString();
                } else if ("gpu".equals(fieldName)) {
                    deserializedCapabilities.gpu = reader.getString();
                } else if ("capabilities".equals(fieldName)) {
                    deserializedCapabilities.capabilities = CapabilitiesCapabilities.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapabilities;
        });
    }
}
