// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies if the IP is exposed to the public internet or private VNET.
 */
public final class ContainerGroupIpAddressType extends ExpandableStringEnum<ContainerGroupIpAddressType> {
    /**
     * Static value Public for ContainerGroupIpAddressType.
     */
    public static final ContainerGroupIpAddressType PUBLIC = fromString("Public");

    /**
     * Static value Private for ContainerGroupIpAddressType.
     */
    public static final ContainerGroupIpAddressType PRIVATE = fromString("Private");

    /**
     * Creates a new instance of ContainerGroupIpAddressType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerGroupIpAddressType() {
    }

    /**
     * Creates or finds a ContainerGroupIpAddressType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContainerGroupIpAddressType.
     */
    public static ContainerGroupIpAddressType fromString(String name) {
        return fromString(name, ContainerGroupIpAddressType.class);
    }

    /**
     * Gets known ContainerGroupIpAddressType values.
     * 
     * @return known ContainerGroupIpAddressType values.
     */
    public static Collection<ContainerGroupIpAddressType> values() {
        return values(ContainerGroupIpAddressType.class);
    }
}
