/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.azure.resourcemanager.containerinstance.models.ContainerProbe;
import com.azure.resourcemanager.containerinstance.models.ContainerPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.ResourceRequirements;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class Container {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Container.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.image", required=true)
    private String image;
    @JsonProperty(value="properties.command")
    private List<String> command;
    @JsonProperty(value="properties.ports")
    private List<ContainerPort> ports;
    @JsonProperty(value="properties.environmentVariables")
    private List<EnvironmentVariable> environmentVariables;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerPropertiesInstanceView instanceView;
    @JsonProperty(value="properties.resources", required=true)
    private ResourceRequirements resources;
    @JsonProperty(value="properties.volumeMounts")
    private List<VolumeMount> volumeMounts;
    @JsonProperty(value="properties.livenessProbe")
    private ContainerProbe livenessProbe;
    @JsonProperty(value="properties.readinessProbe")
    private ContainerProbe readinessProbe;

    public String name() {
        return this.name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    public String image() {
        return this.image;
    }

    public Container withImage(String image) {
        this.image = image;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Container withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<ContainerPort> ports() {
        return this.ports;
    }

    public Container withPorts(List<ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public Container withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public ContainerPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    public ResourceRequirements resources() {
        return this.resources;
    }

    public Container withResources(ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public Container withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public ContainerProbe livenessProbe() {
        return this.livenessProbe;
    }

    public Container withLivenessProbe(ContainerProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    public ContainerProbe readinessProbe() {
        return this.readinessProbe;
    }

    public Container withReadinessProbe(ContainerProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Container"));
        }
        if (this.image() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property image in model Container"));
        }
        if (this.ports() != null) {
            this.ports().forEach(e -> e.validate());
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.resources() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property resources in model Container"));
        }
        this.resources().validate();
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
        if (this.livenessProbe() != null) {
            this.livenessProbe().validate();
        }
        if (this.readinessProbe() != null) {
            this.readinessProbe().validate();
        }
    }
}

