/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.ContainerInstanceOperationsOrigin;
import com.azure.resourcemanager.containerinstance.models.OperationDisplay;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class Operation {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Operation.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="display", required=true)
    private OperationDisplay display;
    @JsonProperty(value="properties")
    private Object properties;
    @JsonProperty(value="origin")
    private ContainerInstanceOperationsOrigin origin;

    public String name() {
        return this.name;
    }

    public Operation withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public Operation withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public Object properties() {
        return this.properties;
    }

    public Operation withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public ContainerInstanceOperationsOrigin origin() {
        return this.origin;
    }

    public Operation withOrigin(ContainerInstanceOperationsOrigin origin) {
        this.origin = origin;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Operation"));
        }
        if (this.display() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property display in model Operation"));
        }
        this.display().validate();
    }
}

