/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.ImportPipelineProperties;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.ImportPipelineSourceProperties;
import com.azure.resourcemanager.containerregistry.models.PipelineOptions;
import com.azure.resourcemanager.containerregistry.models.PipelineTriggerProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ImportPipelineInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImportPipelineInner.class);
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private ImportPipelineProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public String location() {
        return this.location;
    }

    public ImportPipelineInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public IdentityProperties identity() {
        return this.identity;
    }

    public ImportPipelineInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private ImportPipelineProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ImportPipelineSourceProperties source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public ImportPipelineInner withSource(ImportPipelineSourceProperties source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportPipelineProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public PipelineTriggerProperties trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    public ImportPipelineInner withTrigger(PipelineTriggerProperties trigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportPipelineProperties();
        }
        this.innerProperties().withTrigger(trigger);
        return this;
    }

    public List<PipelineOptions> options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public ImportPipelineInner withOptions(List<PipelineOptions> options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImportPipelineProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

