/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.ExportPipelinesClient;
import com.azure.resourcemanager.containerregistry.fluent.models.ExportPipelineInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.ExportPipelineListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExportPipelinesClientImpl
implements ExportPipelinesClient {
    private final ClientLogger logger = new ClientLogger(ExportPipelinesClientImpl.class);
    private final ExportPipelinesService service;
    private final ContainerRegistryManagementClientImpl client;

    ExportPipelinesClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (ExportPipelinesService)RestProxy.create(ExportPipelinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExportPipelineInner>> getWithResponseAsync(String resourceGroupName, String registryName, String exportPipelineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (exportPipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, exportPipelineName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExportPipelineInner>> getWithResponseAsync(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (exportPipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, exportPipelineName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExportPipelineInner> getAsync(String resourceGroupName, String registryName, String exportPipelineName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, exportPipelineName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ExportPipelineInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExportPipelineInner get(String resourceGroupName, String registryName, String exportPipelineName) {
        return (ExportPipelineInner)((Object)this.getAsync(resourceGroupName, registryName, exportPipelineName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExportPipelineInner> getWithResponse(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, exportPipelineName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (exportPipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineName is required and cannot be null."));
        }
        if (exportPipelineCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineCreateParameters is required and cannot be null."));
        }
        exportPipelineCreateParameters.validate();
        String apiVersion = "2019-12-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (exportPipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineName is required and cannot be null."));
        }
        if (exportPipelineCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineCreateParameters is required and cannot be null."));
        }
        exportPipelineCreateParameters.validate();
        String apiVersion = "2019-12-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ExportPipelineInner>, ExportPipelineInner> beginCreateAsync(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ExportPipelineInner.class), (Type)((Object)ExportPipelineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExportPipelineInner>, ExportPipelineInner> beginCreateAsync(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ExportPipelineInner.class), (Type)((Object)ExportPipelineInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExportPipelineInner>, ExportPipelineInner> beginCreate(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExportPipelineInner>, ExportPipelineInner> beginCreate(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExportPipelineInner> createAsync(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExportPipelineInner> createAsync(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExportPipelineInner create(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters) {
        return (ExportPipelineInner)((Object)this.createAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExportPipelineInner create(String resourceGroupName, String registryName, String exportPipelineName, ExportPipelineInner exportPipelineCreateParameters, Context context) {
        return (ExportPipelineInner)((Object)this.createAsync(resourceGroupName, registryName, exportPipelineName, exportPipelineCreateParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String exportPipelineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (exportPipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, exportPipelineName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (exportPipelineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportPipelineName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, exportPipelineName, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String exportPipelineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, exportPipelineName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, exportPipelineName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String exportPipelineName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, exportPipelineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, exportPipelineName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String exportPipelineName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, exportPipelineName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, exportPipelineName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String exportPipelineName) {
        this.deleteAsync(resourceGroupName, registryName, exportPipelineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String exportPipelineName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, exportPipelineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExportPipelineInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExportPipelineListResult)res.getValue()).value(), ((ExportPipelineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExportPipelineInner>> listSinglePageAsync(String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-12-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-12-01-preview", this.client.getSubscriptionId(), resourceGroupName, registryName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExportPipelineListResult)res.getValue()).value(), ((ExportPipelineListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ExportPipelineInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ExportPipelineInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExportPipelineInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExportPipelineInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExportPipelineInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExportPipelineListResult)res.getValue()).value(), ((ExportPipelineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExportPipelineInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExportPipelineListResult)res.getValue()).value(), ((ExportPipelineListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryMan")
    private static interface ExportPipelinesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/exportPipelines/{exportPipelineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExportPipelineInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="exportPipelineName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/exportPipelines/{exportPipelineName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="exportPipelineName") String var6, @BodyParam(value="application/json") ExportPipelineInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/exportPipelines/{exportPipelineName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="exportPipelineName") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/exportPipelines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExportPipelineListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExportPipelineListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

