/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ExportPipelineTargetProperties;
import com.azure.resourcemanager.containerregistry.models.ImportPipelineSourceProperties;
import com.azure.resourcemanager.containerregistry.models.PipelineTriggerDescriptor;
import com.azure.resourcemanager.containerregistry.models.ProgressProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class PipelineRunResponse {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PipelineRunResponse.class);
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="importedArtifacts")
    private List<String> importedArtifacts;
    @JsonProperty(value="progress")
    private ProgressProperties progress;
    @JsonProperty(value="startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="finishTime")
    private OffsetDateTime finishTime;
    @JsonProperty(value="source")
    private ImportPipelineSourceProperties source;
    @JsonProperty(value="target")
    private ExportPipelineTargetProperties target;
    @JsonProperty(value="catalogDigest")
    private String catalogDigest;
    @JsonProperty(value="trigger")
    private PipelineTriggerDescriptor trigger;
    @JsonProperty(value="pipelineRunErrorMessage")
    private String pipelineRunErrorMessage;

    public String status() {
        return this.status;
    }

    public PipelineRunResponse withStatus(String status) {
        this.status = status;
        return this;
    }

    public List<String> importedArtifacts() {
        return this.importedArtifacts;
    }

    public PipelineRunResponse withImportedArtifacts(List<String> importedArtifacts) {
        this.importedArtifacts = importedArtifacts;
        return this;
    }

    public ProgressProperties progress() {
        return this.progress;
    }

    public PipelineRunResponse withProgress(ProgressProperties progress) {
        this.progress = progress;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public PipelineRunResponse withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime finishTime() {
        return this.finishTime;
    }

    public PipelineRunResponse withFinishTime(OffsetDateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public ImportPipelineSourceProperties source() {
        return this.source;
    }

    public PipelineRunResponse withSource(ImportPipelineSourceProperties source) {
        this.source = source;
        return this;
    }

    public ExportPipelineTargetProperties target() {
        return this.target;
    }

    public PipelineRunResponse withTarget(ExportPipelineTargetProperties target) {
        this.target = target;
        return this;
    }

    public String catalogDigest() {
        return this.catalogDigest;
    }

    public PipelineRunResponse withCatalogDigest(String catalogDigest) {
        this.catalogDigest = catalogDigest;
        return this;
    }

    public PipelineTriggerDescriptor trigger() {
        return this.trigger;
    }

    public PipelineRunResponse withTrigger(PipelineTriggerDescriptor trigger) {
        this.trigger = trigger;
        return this;
    }

    public String pipelineRunErrorMessage() {
        return this.pipelineRunErrorMessage;
    }

    public PipelineRunResponse withPipelineRunErrorMessage(String pipelineRunErrorMessage) {
        this.pipelineRunErrorMessage = pipelineRunErrorMessage;
        return this;
    }

    public void validate() {
        if (this.progress() != null) {
            this.progress().validate();
        }
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.target() != null) {
            this.target().validate();
        }
        if (this.trigger() != null) {
            this.trigger().validate();
        }
    }
}

