/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.SourceProperties;
import com.azure.resourcemanager.containerregistry.models.SourceTriggerEvent;
import com.azure.resourcemanager.containerregistry.models.TriggerStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SourceTrigger {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SourceTrigger.class);
    @JsonProperty(value="sourceRepository", required=true)
    private SourceProperties sourceRepository;
    @JsonProperty(value="sourceTriggerEvents", required=true)
    private List<SourceTriggerEvent> sourceTriggerEvents;
    @JsonProperty(value="status")
    private TriggerStatus status;
    @JsonProperty(value="name", required=true)
    private String name;

    public SourceProperties sourceRepository() {
        return this.sourceRepository;
    }

    public SourceTrigger withSourceRepository(SourceProperties sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    public List<SourceTriggerEvent> sourceTriggerEvents() {
        return this.sourceTriggerEvents;
    }

    public SourceTrigger withSourceTriggerEvents(List<SourceTriggerEvent> sourceTriggerEvents) {
        this.sourceTriggerEvents = sourceTriggerEvents;
        return this;
    }

    public TriggerStatus status() {
        return this.status;
    }

    public SourceTrigger withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SourceTrigger withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.sourceRepository() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceRepository in model SourceTrigger"));
        }
        this.sourceRepository().validate();
        if (this.sourceTriggerEvents() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceTriggerEvents in model SourceTrigger"));
        }
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model SourceTrigger"));
        }
    }
}

