// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The properties of a container registry. */
@Fluent
public final class RegistryProperties {
    /*
     * The URL that can be used to log into the container registry.
     */
    @JsonProperty(value = "loginServer", access = JsonProperty.Access.WRITE_ONLY)
    private String loginServer;

    /*
     * The creation date of the container registry in ISO8601 format.
     */
    @JsonProperty(value = "creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;

    /*
     * The provisioning state of the container registry at the time the operation was called.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The status of the container registry at the time the operation was called.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private Status status;

    /*
     * The value that indicates whether the admin user is enabled.
     */
    @JsonProperty(value = "adminUserEnabled")
    private Boolean adminUserEnabled;

    /*
     * The network rule set for a container registry.
     */
    @JsonProperty(value = "networkRuleSet")
    private NetworkRuleSet networkRuleSet;

    /*
     * The policies for a container registry.
     */
    @JsonProperty(value = "policies")
    private Policies policies;

    /*
     * The encryption settings of container registry.
     */
    @JsonProperty(value = "encryption")
    private EncryptionProperty encryption;

    /*
     * Enable a single data endpoint per region for serving data.
     */
    @JsonProperty(value = "dataEndpointEnabled")
    private Boolean dataEndpointEnabled;

    /*
     * List of host names that will serve data when dataEndpointEnabled is true.
     */
    @JsonProperty(value = "dataEndpointHostNames", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> dataEndpointHostNames;

    /*
     * List of private endpoint connections for a container registry.
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /*
     * Whether or not public network access is allowed for the container registry.
     */
    @JsonProperty(value = "publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Whether to allow trusted Azure services to access a network restricted registry.
     */
    @JsonProperty(value = "networkRuleBypassOptions")
    private NetworkRuleBypassOptions networkRuleBypassOptions;

    /*
     * Whether or not zone redundancy is enabled for this container registry
     */
    @JsonProperty(value = "zoneRedundancy")
    private ZoneRedundancy zoneRedundancy;

    /** Creates an instance of RegistryProperties class. */
    public RegistryProperties() {
    }

    /**
     * Get the loginServer property: The URL that can be used to log into the container registry.
     *
     * @return the loginServer value.
     */
    public String loginServer() {
        return this.loginServer;
    }

    /**
     * Get the creationDate property: The creation date of the container registry in ISO8601 format.
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: The provisioning state of the container registry at the time the operation
     * was called.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the status property: The status of the container registry at the time the operation was called.
     *
     * @return the status value.
     */
    public Status status() {
        return this.status;
    }

    /**
     * Get the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     *
     * @return the adminUserEnabled value.
     */
    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    /**
     * Set the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     *
     * @param adminUserEnabled the adminUserEnabled value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    /**
     * Get the networkRuleSet property: The network rule set for a container registry.
     *
     * @return the networkRuleSet value.
     */
    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    /**
     * Set the networkRuleSet property: The network rule set for a container registry.
     *
     * @param networkRuleSet the networkRuleSet value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    /**
     * Get the policies property: The policies for a container registry.
     *
     * @return the policies value.
     */
    public Policies policies() {
        return this.policies;
    }

    /**
     * Set the policies property: The policies for a container registry.
     *
     * @param policies the policies value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    /**
     * Get the encryption property: The encryption settings of container registry.
     *
     * @return the encryption value.
     */
    public EncryptionProperty encryption() {
        return this.encryption;
    }

    /**
     * Set the encryption property: The encryption settings of container registry.
     *
     * @param encryption the encryption value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withEncryption(EncryptionProperty encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the dataEndpointEnabled property: Enable a single data endpoint per region for serving data.
     *
     * @return the dataEndpointEnabled value.
     */
    public Boolean dataEndpointEnabled() {
        return this.dataEndpointEnabled;
    }

    /**
     * Set the dataEndpointEnabled property: Enable a single data endpoint per region for serving data.
     *
     * @param dataEndpointEnabled the dataEndpointEnabled value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        this.dataEndpointEnabled = dataEndpointEnabled;
        return this;
    }

    /**
     * Get the dataEndpointHostNames property: List of host names that will serve data when dataEndpointEnabled is true.
     *
     * @return the dataEndpointHostNames value.
     */
    public List<String> dataEndpointHostNames() {
        return this.dataEndpointHostNames;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections for a container registry.
     *
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public network access is allowed for the container registry.
     *
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public network access is allowed for the container registry.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the networkRuleBypassOptions property: Whether to allow trusted Azure services to access a network restricted
     * registry.
     *
     * @return the networkRuleBypassOptions value.
     */
    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.networkRuleBypassOptions;
    }

    /**
     * Set the networkRuleBypassOptions property: Whether to allow trusted Azure services to access a network restricted
     * registry.
     *
     * @param networkRuleBypassOptions the networkRuleBypassOptions value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        this.networkRuleBypassOptions = networkRuleBypassOptions;
        return this;
    }

    /**
     * Get the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry.
     *
     * @return the zoneRedundancy value.
     */
    public ZoneRedundancy zoneRedundancy() {
        return this.zoneRedundancy;
    }

    /**
     * Set the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry.
     *
     * @param zoneRedundancy the zoneRedundancy value to set.
     * @return the RegistryProperties object itself.
     */
    public RegistryProperties withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        this.zoneRedundancy = zoneRedundancy;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() != null) {
            status().validate();
        }
        if (networkRuleSet() != null) {
            networkRuleSet().validate();
        }
        if (policies() != null) {
            policies().validate();
        }
        if (encryption() != null) {
            encryption().validate();
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}
