/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.resourcemanager.containerregistry.fluent.models.RegistryPropertiesUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class RegistryUpdateParameters {
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties")
    private RegistryPropertiesUpdateParameters innerProperties;

    public IdentityProperties identity() {
        return this.identity;
    }

    public RegistryUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RegistryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public RegistryUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private RegistryPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Boolean adminUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().adminUserEnabled();
    }

    public RegistryUpdateParameters withAdminUserEnabled(Boolean adminUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withAdminUserEnabled(adminUserEnabled);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public RegistryUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public Policies policies() {
        return this.innerProperties() == null ? null : this.innerProperties().policies();
    }

    public RegistryUpdateParameters withPolicies(Policies policies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withPolicies(policies);
        return this;
    }

    public EncryptionProperty encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public RegistryUpdateParameters withEncryption(EncryptionProperty encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEndpointEnabled();
    }

    public RegistryUpdateParameters withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withDataEndpointEnabled(dataEndpointEnabled);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public RegistryUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleBypassOptions();
    }

    public RegistryUpdateParameters withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RegistryPropertiesUpdateParameters();
        }
        this.innerProperties().withNetworkRuleBypassOptions(networkRuleBypassOptions);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

