// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The properties of a credential set resource.
 */
@Fluent
public final class CredentialSetProperties {
    /*
     * The credentials are stored for this upstream or login server.
     */
    @JsonProperty(value = "loginServer")
    private String loginServer;

    /*
     * List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JsonProperty(value = "authCredentials")
    private List<AuthCredential> authCredentials;

    /*
     * The creation date of credential store resource.
     */
    @JsonProperty(value = "creationDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;

    /*
     * Provisioning state of the resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of CredentialSetProperties class.
     */
    public CredentialSetProperties() {
    }

    /**
     * Get the loginServer property: The credentials are stored for this upstream or login server.
     * 
     * @return the loginServer value.
     */
    public String loginServer() {
        return this.loginServer;
    }

    /**
     * Set the loginServer property: The credentials are stored for this upstream or login server.
     * 
     * @param loginServer the loginServer value to set.
     * @return the CredentialSetProperties object itself.
     */
    public CredentialSetProperties withLoginServer(String loginServer) {
        this.loginServer = loginServer;
        return this;
    }

    /**
     * Get the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @return the authCredentials value.
     */
    public List<AuthCredential> authCredentials() {
        return this.authCredentials;
    }

    /**
     * Set the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @param authCredentials the authCredentials value to set.
     * @return the CredentialSetProperties object itself.
     */
    public CredentialSetProperties withAuthCredentials(List<AuthCredential> authCredentials) {
        this.authCredentials = authCredentials;
        return this;
    }

    /**
     * Get the creationDate property: The creation date of credential store resource.
     * 
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (authCredentials() != null) {
            authCredentials().forEach(e -> e.validate());
        }
    }
}
