// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The ReplicationUpdateParametersProperties model.
 */
@Fluent
public final class ReplicationUpdateParametersProperties {
    /*
     * Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication
     * whose regional endpoint is disabled, however its data will continue to be synced with other replications.
     */
    @JsonProperty(value = "regionEndpointEnabled")
    private Boolean regionEndpointEnabled;

    /**
     * Creates an instance of ReplicationUpdateParametersProperties class.
     */
    public ReplicationUpdateParametersProperties() {
    }

    /**
     * Get the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     * 
     * @return the regionEndpointEnabled value.
     */
    public Boolean regionEndpointEnabled() {
        return this.regionEndpointEnabled;
    }

    /**
     * Set the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     * 
     * @param regionEndpointEnabled the regionEndpointEnabled value to set.
     * @return the ReplicationUpdateParametersProperties object itself.
     */
    public ReplicationUpdateParametersProperties withRegionEndpointEnabled(Boolean regionEndpointEnabled) {
        this.regionEndpointEnabled = regionEndpointEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
