// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The current status of the run.
 */
public final class RunStatus extends ExpandableStringEnum<RunStatus> {
    /**
     * Static value Queued for RunStatus.
     */
    public static final RunStatus QUEUED = fromString("Queued");

    /**
     * Static value Started for RunStatus.
     */
    public static final RunStatus STARTED = fromString("Started");

    /**
     * Static value Running for RunStatus.
     */
    public static final RunStatus RUNNING = fromString("Running");

    /**
     * Static value Succeeded for RunStatus.
     */
    public static final RunStatus SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for RunStatus.
     */
    public static final RunStatus FAILED = fromString("Failed");

    /**
     * Static value Canceled for RunStatus.
     */
    public static final RunStatus CANCELED = fromString("Canceled");

    /**
     * Static value Error for RunStatus.
     */
    public static final RunStatus ERROR = fromString("Error");

    /**
     * Static value Timeout for RunStatus.
     */
    public static final RunStatus TIMEOUT = fromString("Timeout");

    /**
     * Creates a new instance of RunStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RunStatus() {
    }

    /**
     * Creates or finds a RunStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RunStatus.
     */
    @JsonCreator
    public static RunStatus fromString(String name) {
        return fromString(name, RunStatus.class);
    }

    /**
     * Gets known RunStatus values.
     * 
     * @return known RunStatus values.
     */
    public static Collection<RunStatus> values() {
        return values(RunStatus.class);
    }
}
