// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The result of get log link operation.
 */
@Fluent
public final class RunGetLogResultInner implements JsonSerializable<RunGetLogResultInner> {
    /*
     * The link to logs for a run on a azure container registry.
     */
    private String logLink;

    /*
     * The link to logs in registry for a run on a azure container registry.
     */
    private String logArtifactLink;

    /**
     * Creates an instance of RunGetLogResultInner class.
     */
    public RunGetLogResultInner() {
    }

    /**
     * Get the logLink property: The link to logs for a run on a azure container registry.
     * 
     * @return the logLink value.
     */
    public String logLink() {
        return this.logLink;
    }

    /**
     * Set the logLink property: The link to logs for a run on a azure container registry.
     * 
     * @param logLink the logLink value to set.
     * @return the RunGetLogResultInner object itself.
     */
    public RunGetLogResultInner withLogLink(String logLink) {
        this.logLink = logLink;
        return this;
    }

    /**
     * Get the logArtifactLink property: The link to logs in registry for a run on a azure container registry.
     * 
     * @return the logArtifactLink value.
     */
    public String logArtifactLink() {
        return this.logArtifactLink;
    }

    /**
     * Set the logArtifactLink property: The link to logs in registry for a run on a azure container registry.
     * 
     * @param logArtifactLink the logArtifactLink value to set.
     * @return the RunGetLogResultInner object itself.
     */
    public RunGetLogResultInner withLogArtifactLink(String logArtifactLink) {
        this.logArtifactLink = logArtifactLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logLink", this.logLink);
        jsonWriter.writeStringField("logArtifactLink", this.logArtifactLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunGetLogResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunGetLogResultInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunGetLogResultInner.
     */
    public static RunGetLogResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunGetLogResultInner deserializedRunGetLogResultInner = new RunGetLogResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("logLink".equals(fieldName)) {
                    deserializedRunGetLogResultInner.logLink = reader.getString();
                } else if ("logArtifactLink".equals(fieldName)) {
                    deserializedRunGetLogResultInner.logArtifactLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunGetLogResultInner;
        });
    }
}
