// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The OS architecture.
 */
public final class Architecture extends ExpandableStringEnum<Architecture> {
    /**
     * Static value amd64 for Architecture.
     */
    public static final Architecture AMD64 = fromString("amd64");

    /**
     * Static value x86 for Architecture.
     */
    public static final Architecture X86 = fromString("x86");

    /**
     * Static value 386 for Architecture.
     */
    public static final Architecture THREE_EIGHT_SIX = fromString("386");

    /**
     * Static value arm for Architecture.
     */
    public static final Architecture ARM = fromString("arm");

    /**
     * Static value arm64 for Architecture.
     */
    public static final Architecture ARM64 = fromString("arm64");

    /**
     * Creates a new instance of Architecture value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Architecture() {
    }

    /**
     * Creates or finds a Architecture from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Architecture.
     */
    public static Architecture fromString(String name) {
        return fromString(name, Architecture.class);
    }

    /**
     * Gets known Architecture values.
     * 
     * @return known Architecture values.
     */
    public static Collection<Architecture> values() {
        return values(Architecture.class);
    }
}
