// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The request parameters for a scheduling run against a task file.
 */
@Fluent
public final class FileTaskRunRequest extends RunRequest {
    /*
     * The type of the run request.
     */
    private String type = "FileTaskRunRequest";

    /*
     * The template/definition file path relative to the source.
     */
    private String taskFilePath;

    /*
     * The values/parameters file path relative to the source.
     */
    private String valuesFilePath;

    /*
     * The collection of overridable values that can be passed when running a task.
     */
    private List<SetValue> values;

    /*
     * Run timeout in seconds.
     */
    private Integer timeout;

    /*
     * The platform properties against which the run has to happen.
     */
    private PlatformProperties platform;

    /*
     * The machine configuration of the run agent.
     */
    private AgentProperties agentConfiguration;

    /*
     * The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    private String sourceLocation;

    /*
     * The properties that describes a set of credentials that will be used when this run is invoked.
     */
    private Credentials credentials;

    /**
     * Creates an instance of FileTaskRunRequest class.
     */
    public FileTaskRunRequest() {
    }

    /**
     * Get the type property: The type of the run request.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the taskFilePath property: The template/definition file path relative to the source.
     * 
     * @return the taskFilePath value.
     */
    public String taskFilePath() {
        return this.taskFilePath;
    }

    /**
     * Set the taskFilePath property: The template/definition file path relative to the source.
     * 
     * @param taskFilePath the taskFilePath value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    /**
     * Get the valuesFilePath property: The values/parameters file path relative to the source.
     * 
     * @return the valuesFilePath value.
     */
    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    /**
     * Set the valuesFilePath property: The values/parameters file path relative to the source.
     * 
     * @param valuesFilePath the valuesFilePath value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    /**
     * Get the values property: The collection of overridable values that can be passed when running a task.
     * 
     * @return the values value.
     */
    public List<SetValue> values() {
        return this.values;
    }

    /**
     * Set the values property: The collection of overridable values that can be passed when running a task.
     * 
     * @param values the values value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the timeout property: Run timeout in seconds.
     * 
     * @return the timeout value.
     */
    public Integer timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: Run timeout in seconds.
     * 
     * @param timeout the timeout value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the platform property: The platform properties against which the run has to happen.
     * 
     * @return the platform value.
     */
    public PlatformProperties platform() {
        return this.platform;
    }

    /**
     * Set the platform property: The platform properties against which the run has to happen.
     * 
     * @param platform the platform value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    /**
     * Get the agentConfiguration property: The machine configuration of the run agent.
     * 
     * @return the agentConfiguration value.
     */
    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    /**
     * Set the agentConfiguration property: The machine configuration of the run agent.
     * 
     * @param agentConfiguration the agentConfiguration value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    /**
     * Get the sourceLocation property: The URL(absolute or relative) of the source context. It can be an URL to a tar
     * or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     * 
     * @return the sourceLocation value.
     */
    public String sourceLocation() {
        return this.sourceLocation;
    }

    /**
     * Set the sourceLocation property: The URL(absolute or relative) of the source context. It can be an URL to a tar
     * or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     * 
     * @param sourceLocation the sourceLocation value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    /**
     * Get the credentials property: The properties that describes a set of credentials that will be used when this run
     * is invoked.
     * 
     * @return the credentials value.
     */
    public Credentials credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: The properties that describes a set of credentials that will be used when this run
     * is invoked.
     * 
     * @param credentials the credentials value to set.
     * @return the FileTaskRunRequest object itself.
     */
    public FileTaskRunRequest withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FileTaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FileTaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FileTaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (taskFilePath() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property taskFilePath in model FileTaskRunRequest"));
        }
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
        if (platform() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property platform in model FileTaskRunRequest"));
        } else {
            platform().validate();
        }
        if (agentConfiguration() != null) {
            agentConfiguration().validate();
        }
        if (credentials() != null) {
            credentials().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FileTaskRunRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isArchiveEnabled", isArchiveEnabled());
        jsonWriter.writeStringField("agentPoolName", agentPoolName());
        jsonWriter.writeStringField("logTemplate", logTemplate());
        jsonWriter.writeStringField("taskFilePath", this.taskFilePath);
        jsonWriter.writeJsonField("platform", this.platform);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("valuesFilePath", this.valuesFilePath);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("timeout", this.timeout);
        jsonWriter.writeJsonField("agentConfiguration", this.agentConfiguration);
        jsonWriter.writeStringField("sourceLocation", this.sourceLocation);
        jsonWriter.writeJsonField("credentials", this.credentials);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileTaskRunRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileTaskRunRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FileTaskRunRequest.
     */
    public static FileTaskRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileTaskRunRequest deserializedFileTaskRunRequest = new FileTaskRunRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedFileTaskRunRequest.withIsArchiveEnabled(reader.getNullable(JsonReader::getBoolean));
                } else if ("agentPoolName".equals(fieldName)) {
                    deserializedFileTaskRunRequest.withAgentPoolName(reader.getString());
                } else if ("logTemplate".equals(fieldName)) {
                    deserializedFileTaskRunRequest.withLogTemplate(reader.getString());
                } else if ("taskFilePath".equals(fieldName)) {
                    deserializedFileTaskRunRequest.taskFilePath = reader.getString();
                } else if ("platform".equals(fieldName)) {
                    deserializedFileTaskRunRequest.platform = PlatformProperties.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    deserializedFileTaskRunRequest.type = reader.getString();
                } else if ("valuesFilePath".equals(fieldName)) {
                    deserializedFileTaskRunRequest.valuesFilePath = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<SetValue> values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    deserializedFileTaskRunRequest.values = values;
                } else if ("timeout".equals(fieldName)) {
                    deserializedFileTaskRunRequest.timeout = reader.getNullable(JsonReader::getInt);
                } else if ("agentConfiguration".equals(fieldName)) {
                    deserializedFileTaskRunRequest.agentConfiguration = AgentProperties.fromJson(reader);
                } else if ("sourceLocation".equals(fieldName)) {
                    deserializedFileTaskRunRequest.sourceLocation = reader.getString();
                } else if ("credentials".equals(fieldName)) {
                    deserializedFileTaskRunRequest.credentials = Credentials.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileTaskRunRequest;
        });
    }
}
