// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request to check whether a container registry name is available.
 */
@Fluent
public final class RegistryNameCheckRequest implements JsonSerializable<RegistryNameCheckRequest> {
    /*
     * The name of the container registry.
     */
    private String name;

    /*
     * The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
     */
    private String type = "Microsoft.ContainerRegistry/registries";

    /**
     * Creates an instance of RegistryNameCheckRequest class.
     */
    public RegistryNameCheckRequest() {
    }

    /**
     * Get the name property: The name of the container registry.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the container registry.
     * 
     * @param name the name value to set.
     * @return the RegistryNameCheckRequest object itself.
     */
    public RegistryNameCheckRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The resource type of the container registry. This field must be set to
     * 'Microsoft.ContainerRegistry/registries'.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The resource type of the container registry. This field must be set to
     * 'Microsoft.ContainerRegistry/registries'.
     * 
     * @param type the type value to set.
     * @return the RegistryNameCheckRequest object itself.
     */
    public RegistryNameCheckRequest withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model RegistryNameCheckRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RegistryNameCheckRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegistryNameCheckRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegistryNameCheckRequest if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RegistryNameCheckRequest.
     */
    public static RegistryNameCheckRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegistryNameCheckRequest deserializedRegistryNameCheckRequest = new RegistryNameCheckRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRegistryNameCheckRequest.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegistryNameCheckRequest;
        });
    }
}
