// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ReplicationUpdateParametersProperties;
import java.io.IOException;
import java.util.Map;

/**
 * The parameters for updating a replication.
 */
@Fluent
public final class ReplicationUpdateParameters implements JsonSerializable<ReplicationUpdateParameters> {
    /*
     * The tags for the replication.
     */
    private Map<String, String> tags;

    /*
     * The parameters for updating a replication's properties
     */
    private ReplicationUpdateParametersProperties innerProperties;

    /**
     * Creates an instance of ReplicationUpdateParameters class.
     */
    public ReplicationUpdateParameters() {
    }

    /**
     * Get the tags property: The tags for the replication.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags for the replication.
     * 
     * @param tags the tags value to set.
     * @return the ReplicationUpdateParameters object itself.
     */
    public ReplicationUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The parameters for updating a replication's properties.
     * 
     * @return the innerProperties value.
     */
    private ReplicationUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     * 
     * @return the regionEndpointEnabled value.
     */
    public Boolean regionEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().regionEndpointEnabled();
    }

    /**
     * Set the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     * 
     * @param regionEndpointEnabled the regionEndpointEnabled value to set.
     * @return the ReplicationUpdateParameters object itself.
     */
    public ReplicationUpdateParameters withRegionEndpointEnabled(Boolean regionEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicationUpdateParametersProperties();
        }
        this.innerProperties().withRegionEndpointEnabled(regionEndpointEnabled);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReplicationUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReplicationUpdateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ReplicationUpdateParameters.
     */
    public static ReplicationUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReplicationUpdateParameters deserializedReplicationUpdateParameters = new ReplicationUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedReplicationUpdateParameters.tags = tags;
                } else if ("properties".equals(fieldName)) {
                    deserializedReplicationUpdateParameters.innerProperties
                        = ReplicationUpdateParametersProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReplicationUpdateParameters;
        });
    }
}
