// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunPropertiesUpdateParameters;
import java.io.IOException;
import java.util.Map;

/**
 * The parameters for updating a task run.
 */
@Fluent
public final class TaskRunUpdateParameters implements JsonSerializable<TaskRunUpdateParameters> {
    /*
     * Identity for the resource.
     */
    private IdentityProperties identity;

    /*
     * The properties for updating a task run.
     */
    private TaskRunPropertiesUpdateParameters innerProperties;

    /*
     * The location of the resource
     */
    private String location;

    /*
     * The ARM resource tags.
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of TaskRunUpdateParameters class.
     */
    public TaskRunUpdateParameters() {
    }

    /**
     * Get the identity property: Identity for the resource.
     * 
     * @return the identity value.
     */
    public IdentityProperties identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity for the resource.
     * 
     * @param identity the identity value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The properties for updating a task run.
     * 
     * @return the innerProperties value.
     */
    private TaskRunPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the location property: The location of the resource.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the resource.
     * 
     * @param location the location value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags property: The ARM resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The ARM resource tags.
     * 
     * @param tags the tags value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the runRequest property: The request (parameters) for the new run.
     * 
     * @return the runRequest value.
     */
    public RunRequest runRequest() {
        return this.innerProperties() == null ? null : this.innerProperties().runRequest();
    }

    /**
     * Set the runRequest property: The request (parameters) for the new run.
     * 
     * @param runRequest the runRequest value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withRunRequest(RunRequest runRequest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withRunRequest(runRequest);
        return this;
    }

    /**
     * Get the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @return the forceUpdateTag value.
     */
    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    /**
     * Set the forceUpdateTag property: How the run should be forced to rerun even if the run request configuration has
     * not changed.
     * 
     * @param forceUpdateTag the forceUpdateTag value to set.
     * @return the TaskRunUpdateParameters object itself.
     */
    public TaskRunUpdateParameters withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskRunPropertiesUpdateParameters();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TaskRunUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TaskRunUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TaskRunUpdateParameters.
     */
    public static TaskRunUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TaskRunUpdateParameters deserializedTaskRunUpdateParameters = new TaskRunUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedTaskRunUpdateParameters.identity = IdentityProperties.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedTaskRunUpdateParameters.innerProperties
                        = TaskRunPropertiesUpdateParameters.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedTaskRunUpdateParameters.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTaskRunUpdateParameters.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTaskRunUpdateParameters;
        });
    }
}
