// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The properties of a certificate used for authenticating a token.
 */
@Fluent
public final class TokenCertificate implements JsonSerializable<TokenCertificate> {
    /*
     * The name property.
     */
    private TokenCertificateName name;

    /*
     * The expiry datetime of the certificate.
     */
    private OffsetDateTime expiry;

    /*
     * The thumbprint of the certificate.
     */
    private String thumbprint;

    /*
     * Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
     */
    private String encodedPemCertificate;

    /**
     * Creates an instance of TokenCertificate class.
     */
    public TokenCertificate() {
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public TokenCertificateName name() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the TokenCertificate object itself.
     */
    public TokenCertificate withName(TokenCertificateName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the expiry property: The expiry datetime of the certificate.
     * 
     * @return the expiry value.
     */
    public OffsetDateTime expiry() {
        return this.expiry;
    }

    /**
     * Set the expiry property: The expiry datetime of the certificate.
     * 
     * @param expiry the expiry value to set.
     * @return the TokenCertificate object itself.
     */
    public TokenCertificate withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    /**
     * Get the thumbprint property: The thumbprint of the certificate.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint property: The thumbprint of the certificate.
     * 
     * @param thumbprint the thumbprint value to set.
     * @return the TokenCertificate object itself.
     */
    public TokenCertificate withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Get the encodedPemCertificate property: Base 64 encoded string of the public certificate1 in PEM format that will
     * be used for authenticating the token.
     * 
     * @return the encodedPemCertificate value.
     */
    public String encodedPemCertificate() {
        return this.encodedPemCertificate;
    }

    /**
     * Set the encodedPemCertificate property: Base 64 encoded string of the public certificate1 in PEM format that will
     * be used for authenticating the token.
     * 
     * @param encodedPemCertificate the encodedPemCertificate value to set.
     * @return the TokenCertificate object itself.
     */
    public TokenCertificate withEncodedPemCertificate(String encodedPemCertificate) {
        this.encodedPemCertificate = encodedPemCertificate;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("expiry",
            this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("encodedPemCertificate", this.encodedPemCertificate);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenCertificate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenCertificate if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TokenCertificate.
     */
    public static TokenCertificate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenCertificate deserializedTokenCertificate = new TokenCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedTokenCertificate.name = TokenCertificateName.fromString(reader.getString());
                } else if ("expiry".equals(fieldName)) {
                    deserializedTokenCertificate.expiry = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedTokenCertificate.thumbprint = reader.getString();
                } else if ("encodedPemCertificate".equals(fieldName)) {
                    deserializedTokenCertificate.encodedPemCertificate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenCertificate;
        });
    }
}
