// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties for updating the platform configuration.
 */
@Fluent
public final class PlatformUpdateParameters implements JsonSerializable<PlatformUpdateParameters> {
    /*
     * The operating system type required for the run.
     */
    private OS os;

    /*
     * The OS architecture.
     */
    private Architecture architecture;

    /*
     * Variant of the CPU.
     */
    private Variant variant;

    /**
     * Creates an instance of PlatformUpdateParameters class.
     */
    public PlatformUpdateParameters() {
    }

    /**
     * Get the os property: The operating system type required for the run.
     * 
     * @return the os value.
     */
    public OS os() {
        return this.os;
    }

    /**
     * Set the os property: The operating system type required for the run.
     * 
     * @param os the os value to set.
     * @return the PlatformUpdateParameters object itself.
     */
    public PlatformUpdateParameters withOs(OS os) {
        this.os = os;
        return this;
    }

    /**
     * Get the architecture property: The OS architecture.
     * 
     * @return the architecture value.
     */
    public Architecture architecture() {
        return this.architecture;
    }

    /**
     * Set the architecture property: The OS architecture.
     * 
     * @param architecture the architecture value to set.
     * @return the PlatformUpdateParameters object itself.
     */
    public PlatformUpdateParameters withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    /**
     * Get the variant property: Variant of the CPU.
     * 
     * @return the variant value.
     */
    public Variant variant() {
        return this.variant;
    }

    /**
     * Set the variant property: Variant of the CPU.
     * 
     * @param variant the variant value to set.
     * @return the PlatformUpdateParameters object itself.
     */
    public PlatformUpdateParameters withVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("os", this.os == null ? null : this.os.toString());
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeStringField("variant", this.variant == null ? null : this.variant.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PlatformUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PlatformUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PlatformUpdateParameters.
     */
    public static PlatformUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PlatformUpdateParameters deserializedPlatformUpdateParameters = new PlatformUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("os".equals(fieldName)) {
                    deserializedPlatformUpdateParameters.os = OS.fromString(reader.getString());
                } else if ("architecture".equals(fieldName)) {
                    deserializedPlatformUpdateParameters.architecture = Architecture.fromString(reader.getString());
                } else if ("variant".equals(fieldName)) {
                    deserializedPlatformUpdateParameters.variant = Variant.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPlatformUpdateParameters;
        });
    }
}
