/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WebhookPropertiesCreateParameters
implements JsonSerializable<WebhookPropertiesCreateParameters> {
    private String serviceUri;
    private Map<String, String> customHeaders;
    private WebhookStatus status;
    private String scope;
    private List<WebhookAction> actions;
    private static final ClientLogger LOGGER = new ClientLogger(WebhookPropertiesCreateParameters.class);

    public String serviceUri() {
        return this.serviceUri;
    }

    public WebhookPropertiesCreateParameters withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    public WebhookPropertiesCreateParameters withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public WebhookStatus status() {
        return this.status;
    }

    public WebhookPropertiesCreateParameters withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public WebhookPropertiesCreateParameters withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<WebhookAction> actions() {
        return this.actions;
    }

    public WebhookPropertiesCreateParameters withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.serviceUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serviceUri in model WebhookPropertiesCreateParameters"));
        }
        if (this.actions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actions in model WebhookPropertiesCreateParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceUri", this.serviceUri);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeMapField("customHeaders", this.customHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("scope", this.scope);
        return jsonWriter.writeEndObject();
    }

    public static WebhookPropertiesCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookPropertiesCreateParameters)jsonReader.readObject(reader -> {
            WebhookPropertiesCreateParameters deserializedWebhookPropertiesCreateParameters = new WebhookPropertiesCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceUri".equals(fieldName)) {
                    deserializedWebhookPropertiesCreateParameters.serviceUri = reader.getString();
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedWebhookPropertiesCreateParameters.actions = actions = reader.readArray(reader1 -> WebhookAction.fromString(reader1.getString()));
                    continue;
                }
                if ("customHeaders".equals(fieldName)) {
                    Map customHeaders;
                    deserializedWebhookPropertiesCreateParameters.customHeaders = customHeaders = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedWebhookPropertiesCreateParameters.status = WebhookStatus.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedWebhookPropertiesCreateParameters.scope = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookPropertiesCreateParameters;
        });
    }
}

