/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.CustomRegistryCredentials;
import com.azure.resourcemanager.containerregistry.models.SourceRegistryCredentials;
import java.io.IOException;
import java.util.Map;

public final class Credentials
implements JsonSerializable<Credentials> {
    private SourceRegistryCredentials sourceRegistry;
    private Map<String, CustomRegistryCredentials> customRegistries;

    public SourceRegistryCredentials sourceRegistry() {
        return this.sourceRegistry;
    }

    public Credentials withSourceRegistry(SourceRegistryCredentials sourceRegistry) {
        this.sourceRegistry = sourceRegistry;
        return this;
    }

    public Map<String, CustomRegistryCredentials> customRegistries() {
        return this.customRegistries;
    }

    public Credentials withCustomRegistries(Map<String, CustomRegistryCredentials> customRegistries) {
        this.customRegistries = customRegistries;
        return this;
    }

    public void validate() {
        if (this.sourceRegistry() != null) {
            this.sourceRegistry().validate();
        }
        if (this.customRegistries() != null) {
            this.customRegistries().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceRegistry", (JsonSerializable)this.sourceRegistry);
        jsonWriter.writeMapField("customRegistries", this.customRegistries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Credentials fromJson(JsonReader jsonReader) throws IOException {
        return (Credentials)jsonReader.readObject(reader -> {
            Credentials deserializedCredentials = new Credentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRegistry".equals(fieldName)) {
                    deserializedCredentials.sourceRegistry = SourceRegistryCredentials.fromJson(reader);
                    continue;
                }
                if ("customRegistries".equals(fieldName)) {
                    Map customRegistries;
                    deserializedCredentials.customRegistries = customRegistries = reader.readMap(reader1 -> CustomRegistryCredentials.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentials;
        });
    }
}

