/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.azure.resourcemanager.containerregistry.models.StepType;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import java.io.IOException;
import java.util.List;

public final class EncodedTaskStepUpdateParameters
extends TaskStepUpdateParameters {
    private StepType type = StepType.ENCODED_TASK;
    private String encodedTaskContent;
    private String encodedValuesContent;
    private List<SetValue> values;

    @Override
    public StepType type() {
        return this.type;
    }

    public String encodedTaskContent() {
        return this.encodedTaskContent;
    }

    public EncodedTaskStepUpdateParameters withEncodedTaskContent(String encodedTaskContent) {
        this.encodedTaskContent = encodedTaskContent;
        return this;
    }

    public String encodedValuesContent() {
        return this.encodedValuesContent;
    }

    public EncodedTaskStepUpdateParameters withEncodedValuesContent(String encodedValuesContent) {
        this.encodedValuesContent = encodedValuesContent;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public EncodedTaskStepUpdateParameters withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public EncodedTaskStepUpdateParameters withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public EncodedTaskStepUpdateParameters withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath());
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("encodedTaskContent", this.encodedTaskContent);
        jsonWriter.writeStringField("encodedValuesContent", this.encodedValuesContent);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EncodedTaskStepUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (EncodedTaskStepUpdateParameters)jsonReader.readObject(reader -> {
            EncodedTaskStepUpdateParameters deserializedEncodedTaskStepUpdateParameters = new EncodedTaskStepUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contextPath".equals(fieldName)) {
                    deserializedEncodedTaskStepUpdateParameters.withContextPath(reader.getString());
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedEncodedTaskStepUpdateParameters.withContextAccessToken(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEncodedTaskStepUpdateParameters.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("encodedTaskContent".equals(fieldName)) {
                    deserializedEncodedTaskStepUpdateParameters.encodedTaskContent = reader.getString();
                    continue;
                }
                if ("encodedValuesContent".equals(fieldName)) {
                    deserializedEncodedTaskStepUpdateParameters.encodedValuesContent = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedEncodedTaskStepUpdateParameters.values = values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncodedTaskStepUpdateParameters;
        });
    }
}

