/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import java.io.IOException;
import java.util.List;

public final class RegistryListResult
implements JsonSerializable<RegistryListResult> {
    private List<RegistryInner> value;
    private String nextLink;

    public List<RegistryInner> value() {
        return this.value;
    }

    public RegistryListResult withValue(List<RegistryInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public RegistryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static RegistryListResult fromJson(JsonReader jsonReader) throws IOException {
        return (RegistryListResult)jsonReader.readObject(reader -> {
            RegistryListResult deserializedRegistryListResult = new RegistryListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRegistryListResult.value = value = reader.readArray(reader1 -> RegistryInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedRegistryListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryListResult;
        });
    }
}

