// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The AgentPoolPropertiesUpdateParameters model.
 */
@Fluent
public final class AgentPoolPropertiesUpdateParameters
    implements JsonSerializable<AgentPoolPropertiesUpdateParameters> {
    /*
     * The count of agent machine
     */
    private Integer count;

    /**
     * Creates an instance of AgentPoolPropertiesUpdateParameters class.
     */
    public AgentPoolPropertiesUpdateParameters() {
    }

    /**
     * Get the count property: The count of agent machine.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The count of agent machine.
     * 
     * @param count the count value to set.
     * @return the AgentPoolPropertiesUpdateParameters object itself.
     */
    public AgentPoolPropertiesUpdateParameters withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolPropertiesUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolPropertiesUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolPropertiesUpdateParameters.
     */
    public static AgentPoolPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolPropertiesUpdateParameters deserializedAgentPoolPropertiesUpdateParameters
                = new AgentPoolPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedAgentPoolPropertiesUpdateParameters.count = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolPropertiesUpdateParameters;
        });
    }
}
