// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The policies for a container registry.
 */
@Fluent
public final class Policies implements JsonSerializable<Policies> {
    /*
     * The quarantine policy for a container registry.
     */
    private QuarantinePolicy quarantinePolicy;

    /*
     * The content trust policy for a container registry.
     */
    private TrustPolicy trustPolicy;

    /*
     * The retention policy for a container registry.
     */
    private RetentionPolicy retentionPolicy;

    /*
     * The export policy for a container registry.
     */
    private ExportPolicy exportPolicy;

    /**
     * Creates an instance of Policies class.
     */
    public Policies() {
    }

    /**
     * Get the quarantinePolicy property: The quarantine policy for a container registry.
     * 
     * @return the quarantinePolicy value.
     */
    public QuarantinePolicy quarantinePolicy() {
        return this.quarantinePolicy;
    }

    /**
     * Set the quarantinePolicy property: The quarantine policy for a container registry.
     * 
     * @param quarantinePolicy the quarantinePolicy value to set.
     * @return the Policies object itself.
     */
    public Policies withQuarantinePolicy(QuarantinePolicy quarantinePolicy) {
        this.quarantinePolicy = quarantinePolicy;
        return this;
    }

    /**
     * Get the trustPolicy property: The content trust policy for a container registry.
     * 
     * @return the trustPolicy value.
     */
    public TrustPolicy trustPolicy() {
        return this.trustPolicy;
    }

    /**
     * Set the trustPolicy property: The content trust policy for a container registry.
     * 
     * @param trustPolicy the trustPolicy value to set.
     * @return the Policies object itself.
     */
    public Policies withTrustPolicy(TrustPolicy trustPolicy) {
        this.trustPolicy = trustPolicy;
        return this;
    }

    /**
     * Get the retentionPolicy property: The retention policy for a container registry.
     * 
     * @return the retentionPolicy value.
     */
    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: The retention policy for a container registry.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the Policies object itself.
     */
    public Policies withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    /**
     * Get the exportPolicy property: The export policy for a container registry.
     * 
     * @return the exportPolicy value.
     */
    public ExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    /**
     * Set the exportPolicy property: The export policy for a container registry.
     * 
     * @param exportPolicy the exportPolicy value to set.
     * @return the Policies object itself.
     */
    public Policies withExportPolicy(ExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (quarantinePolicy() != null) {
            quarantinePolicy().validate();
        }
        if (trustPolicy() != null) {
            trustPolicy().validate();
        }
        if (retentionPolicy() != null) {
            retentionPolicy().validate();
        }
        if (exportPolicy() != null) {
            exportPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("quarantinePolicy", this.quarantinePolicy);
        jsonWriter.writeJsonField("trustPolicy", this.trustPolicy);
        jsonWriter.writeJsonField("retentionPolicy", this.retentionPolicy);
        jsonWriter.writeJsonField("exportPolicy", this.exportPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Policies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Policies if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Policies.
     */
    public static Policies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Policies deserializedPolicies = new Policies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("quarantinePolicy".equals(fieldName)) {
                    deserializedPolicies.quarantinePolicy = QuarantinePolicy.fromJson(reader);
                } else if ("trustPolicy".equals(fieldName)) {
                    deserializedPolicies.trustPolicy = TrustPolicy.fromJson(reader);
                } else if ("retentionPolicy".equals(fieldName)) {
                    deserializedPolicies.retentionPolicy = RetentionPolicy.fromJson(reader);
                } else if ("exportPolicy".equals(fieldName)) {
                    deserializedPolicies.exportPolicy = ExportPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicies;
        });
    }
}
