// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The set of run properties that can be updated.
 */
@Fluent
public final class RunUpdateParameters implements JsonSerializable<RunUpdateParameters> {
    /*
     * The value that indicates whether archiving is enabled or not.
     */
    private Boolean isArchiveEnabled;

    /**
     * Creates an instance of RunUpdateParameters class.
     */
    public RunUpdateParameters() {
    }

    /**
     * Get the isArchiveEnabled property: The value that indicates whether archiving is enabled or not.
     * 
     * @return the isArchiveEnabled value.
     */
    public Boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    /**
     * Set the isArchiveEnabled property: The value that indicates whether archiving is enabled or not.
     * 
     * @param isArchiveEnabled the isArchiveEnabled value to set.
     * @return the RunUpdateParameters object itself.
     */
    public RunUpdateParameters withIsArchiveEnabled(Boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunUpdateParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunUpdateParameters.
     */
    public static RunUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunUpdateParameters deserializedRunUpdateParameters = new RunUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedRunUpdateParameters.isArchiveEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunUpdateParameters;
        });
    }
}
