// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import java.io.IOException;
import java.util.List;

/**
 * The properties of a webhook.
 */
@Fluent
public final class WebhookProperties implements JsonSerializable<WebhookProperties> {
    /*
     * The status of the webhook at the time the operation was called.
     */
    private WebhookStatus status;

    /*
     * The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under
     * repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all
     * events.
     */
    private String scope;

    /*
     * The list of actions that trigger the webhook to post notifications.
     */
    private List<WebhookAction> actions;

    /*
     * The provisioning state of the webhook at the time the operation was called.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of WebhookProperties class.
     */
    public WebhookProperties() {
    }

    /**
     * Get the status property: The status of the webhook at the time the operation was called.
     * 
     * @return the status value.
     */
    public WebhookStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the webhook at the time the operation was called.
     * 
     * @param status the status value to set.
     * @return the WebhookProperties object itself.
     */
    public WebhookProperties withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the scope property: The scope of repositories where the event can be triggered. For example, 'foo:*' means
     * events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     * 'foo:latest'. Empty means all events.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The scope of repositories where the event can be triggered. For example, 'foo:*' means
     * events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to
     * 'foo:latest'. Empty means all events.
     * 
     * @param scope the scope value to set.
     * @return the WebhookProperties object itself.
     */
    public WebhookProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the actions property: The list of actions that trigger the webhook to post notifications.
     * 
     * @return the actions value.
     */
    public List<WebhookAction> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The list of actions that trigger the webhook to post notifications.
     * 
     * @param actions the actions value to set.
     * @return the WebhookProperties object itself.
     */
    public WebhookProperties withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the webhook at the time the operation was called.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (actions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property actions in model WebhookProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebhookProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("actions", this.actions,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("scope", this.scope);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebhookProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebhookProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebhookProperties.
     */
    public static WebhookProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebhookProperties deserializedWebhookProperties = new WebhookProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actions".equals(fieldName)) {
                    List<WebhookAction> actions
                        = reader.readArray(reader1 -> WebhookAction.fromString(reader1.getString()));
                    deserializedWebhookProperties.actions = actions;
                } else if ("status".equals(fieldName)) {
                    deserializedWebhookProperties.status = WebhookStatus.fromString(reader.getString());
                } else if ("scope".equals(fieldName)) {
                    deserializedWebhookProperties.scope = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedWebhookProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebhookProperties;
        });
    }
}
