// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The target of the event.
 */
@Fluent
public final class Target implements JsonSerializable<Target> {
    /*
     * The MIME type of the referenced object.
     */
    private String mediaType;

    /*
     * The number of bytes of the content. Same as Length field.
     */
    private Long size;

    /*
     * The digest of the content, as defined by the Registry V2 HTTP API Specification.
     */
    private String digest;

    /*
     * The number of bytes of the content. Same as Size field.
     */
    private Long length;

    /*
     * The repository name.
     */
    private String repository;

    /*
     * The direct URL to the content.
     */
    private String url;

    /*
     * The tag name.
     */
    private String tag;

    /*
     * The name of the artifact.
     */
    private String name;

    /*
     * The version of the artifact.
     */
    private String version;

    /**
     * Creates an instance of Target class.
     */
    public Target() {
    }

    /**
     * Get the mediaType property: The MIME type of the referenced object.
     * 
     * @return the mediaType value.
     */
    public String mediaType() {
        return this.mediaType;
    }

    /**
     * Set the mediaType property: The MIME type of the referenced object.
     * 
     * @param mediaType the mediaType value to set.
     * @return the Target object itself.
     */
    public Target withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    /**
     * Get the size property: The number of bytes of the content. Same as Length field.
     * 
     * @return the size value.
     */
    public Long size() {
        return this.size;
    }

    /**
     * Set the size property: The number of bytes of the content. Same as Length field.
     * 
     * @param size the size value to set.
     * @return the Target object itself.
     */
    public Target withSize(Long size) {
        this.size = size;
        return this;
    }

    /**
     * Get the digest property: The digest of the content, as defined by the Registry V2 HTTP API Specification.
     * 
     * @return the digest value.
     */
    public String digest() {
        return this.digest;
    }

    /**
     * Set the digest property: The digest of the content, as defined by the Registry V2 HTTP API Specification.
     * 
     * @param digest the digest value to set.
     * @return the Target object itself.
     */
    public Target withDigest(String digest) {
        this.digest = digest;
        return this;
    }

    /**
     * Get the length property: The number of bytes of the content. Same as Size field.
     * 
     * @return the length value.
     */
    public Long length() {
        return this.length;
    }

    /**
     * Set the length property: The number of bytes of the content. Same as Size field.
     * 
     * @param length the length value to set.
     * @return the Target object itself.
     */
    public Target withLength(Long length) {
        this.length = length;
        return this;
    }

    /**
     * Get the repository property: The repository name.
     * 
     * @return the repository value.
     */
    public String repository() {
        return this.repository;
    }

    /**
     * Set the repository property: The repository name.
     * 
     * @param repository the repository value to set.
     * @return the Target object itself.
     */
    public Target withRepository(String repository) {
        this.repository = repository;
        return this;
    }

    /**
     * Get the url property: The direct URL to the content.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: The direct URL to the content.
     * 
     * @param url the url value to set.
     * @return the Target object itself.
     */
    public Target withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the tag property: The tag name.
     * 
     * @return the tag value.
     */
    public String tag() {
        return this.tag;
    }

    /**
     * Set the tag property: The tag name.
     * 
     * @param tag the tag value to set.
     * @return the Target object itself.
     */
    public Target withTag(String tag) {
        this.tag = tag;
        return this;
    }

    /**
     * Get the name property: The name of the artifact.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the artifact.
     * 
     * @param name the name value to set.
     * @return the Target object itself.
     */
    public Target withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the version property: The version of the artifact.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The version of the artifact.
     * 
     * @param version the version value to set.
     * @return the Target object itself.
     */
    public Target withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mediaType", this.mediaType);
        jsonWriter.writeNumberField("size", this.size);
        jsonWriter.writeStringField("digest", this.digest);
        jsonWriter.writeNumberField("length", this.length);
        jsonWriter.writeStringField("repository", this.repository);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("tag", this.tag);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Target from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Target if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Target.
     */
    public static Target fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Target deserializedTarget = new Target();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mediaType".equals(fieldName)) {
                    deserializedTarget.mediaType = reader.getString();
                } else if ("size".equals(fieldName)) {
                    deserializedTarget.size = reader.getNullable(JsonReader::getLong);
                } else if ("digest".equals(fieldName)) {
                    deserializedTarget.digest = reader.getString();
                } else if ("length".equals(fieldName)) {
                    deserializedTarget.length = reader.getNullable(JsonReader::getLong);
                } else if ("repository".equals(fieldName)) {
                    deserializedTarget.repository = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedTarget.url = reader.getString();
                } else if ("tag".equals(fieldName)) {
                    deserializedTarget.tag = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTarget.name = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedTarget.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTarget;
        });
    }
}
