/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AuthInfo;
import com.azure.resourcemanager.containerregistry.models.SourceControlType;
import java.io.IOException;

public final class SourceProperties
implements JsonSerializable<SourceProperties> {
    private SourceControlType sourceControlType;
    private String repositoryUrl;
    private String branch;
    private AuthInfo sourceControlAuthProperties;
    private static final ClientLogger LOGGER = new ClientLogger(SourceProperties.class);

    public SourceControlType sourceControlType() {
        return this.sourceControlType;
    }

    public SourceProperties withSourceControlType(SourceControlType sourceControlType) {
        this.sourceControlType = sourceControlType;
        return this;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public SourceProperties withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public SourceProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public AuthInfo sourceControlAuthProperties() {
        return this.sourceControlAuthProperties;
    }

    public SourceProperties withSourceControlAuthProperties(AuthInfo sourceControlAuthProperties) {
        this.sourceControlAuthProperties = sourceControlAuthProperties;
        return this;
    }

    public void validate() {
        if (this.sourceControlType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceControlType in model SourceProperties"));
        }
        if (this.repositoryUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property repositoryUrl in model SourceProperties"));
        }
        if (this.sourceControlAuthProperties() != null) {
            this.sourceControlAuthProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceControlType", this.sourceControlType == null ? null : this.sourceControlType.toString());
        jsonWriter.writeStringField("repositoryUrl", this.repositoryUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeJsonField("sourceControlAuthProperties", (JsonSerializable)this.sourceControlAuthProperties);
        return jsonWriter.writeEndObject();
    }

    public static SourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceProperties)jsonReader.readObject(reader -> {
            SourceProperties deserializedSourceProperties = new SourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceControlType".equals(fieldName)) {
                    deserializedSourceProperties.sourceControlType = SourceControlType.fromString(reader.getString());
                    continue;
                }
                if ("repositoryUrl".equals(fieldName)) {
                    deserializedSourceProperties.repositoryUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedSourceProperties.branch = reader.getString();
                    continue;
                }
                if ("sourceControlAuthProperties".equals(fieldName)) {
                    deserializedSourceProperties.sourceControlAuthProperties = AuthInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceProperties;
        });
    }
}

