/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.AgentPoolProperties;
import com.azure.resourcemanager.containerregistry.models.OS;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class AgentPoolInner
extends Resource {
    private AgentPoolProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private AgentPoolProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AgentPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AgentPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer count() {
        return this.innerProperties() == null ? null : this.innerProperties().count();
    }

    public AgentPoolInner withCount(Integer count) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withCount(count);
        return this;
    }

    public String tier() {
        return this.innerProperties() == null ? null : this.innerProperties().tier();
    }

    public AgentPoolInner withTier(String tier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withTier(tier);
        return this;
    }

    public OS os() {
        return this.innerProperties() == null ? null : this.innerProperties().os();
    }

    public AgentPoolInner withOs(OS os) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withOs(os);
        return this;
    }

    public String virtualNetworkSubnetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkSubnetResourceId();
    }

    public AgentPoolInner withVirtualNetworkSubnetResourceId(String virtualNetworkSubnetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withVirtualNetworkSubnetResourceId(virtualNetworkSubnetResourceId);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolInner)((Object)jsonReader.readObject(reader -> {
            AgentPoolInner deserializedAgentPoolInner = new AgentPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAgentPoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAgentPoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAgentPoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAgentPoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAgentPoolInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolInner.innerProperties = AgentPoolProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAgentPoolInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolInner;
        }));
    }
}

