/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.PolicyStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RetentionPolicy
implements JsonSerializable<RetentionPolicy> {
    private Integer days;
    private OffsetDateTime lastUpdatedTime;
    private PolicyStatus status;

    public Integer days() {
        return this.days;
    }

    public RetentionPolicy withDays(Integer days) {
        this.days = days;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public PolicyStatus status() {
        return this.status;
    }

    public RetentionPolicy withStatus(PolicyStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("days", (Number)this.days);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static RetentionPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (RetentionPolicy)jsonReader.readObject(reader -> {
            RetentionPolicy deserializedRetentionPolicy = new RetentionPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("days".equals(fieldName)) {
                    deserializedRetentionPolicy.days = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedRetentionPolicy.lastUpdatedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRetentionPolicy.status = PolicyStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRetentionPolicy;
        });
    }
}

