// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerregistry.fluent.WebhooksClient;
import com.azure.resourcemanager.containerregistry.fluent.models.CallbackConfigInner;
import com.azure.resourcemanager.containerregistry.fluent.models.EventInfoInner;
import com.azure.resourcemanager.containerregistry.fluent.models.EventInner;
import com.azure.resourcemanager.containerregistry.fluent.models.WebhookInner;
import com.azure.resourcemanager.containerregistry.models.EventListResult;
import com.azure.resourcemanager.containerregistry.models.WebhookCreateParameters;
import com.azure.resourcemanager.containerregistry.models.WebhookListResult;
import com.azure.resourcemanager.containerregistry.models.WebhookUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in WebhooksClient. */
public final class WebhooksClientImpl implements WebhooksClient {
    private final ClientLogger logger = new ClientLogger(WebhooksClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final WebhooksService service;

    /** The service client containing this operation class. */
    private final ContainerRegistryManagementClientImpl client;

    /**
     * Initializes an instance of WebhooksClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    WebhooksClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = RestProxy.create(WebhooksService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerRegistryManagementClientWebhooks to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerRegistryMan")
    private interface WebhooksService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<WebhookInner>> get(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            @BodyParam("application/json") WebhookCreateParameters webhookCreateParameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            @BodyParam("application/json") WebhookUpdateParameters webhookUpdateParameters,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<WebhookListResult>> list(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}/ping")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EventInfoInner>> ping(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}/getCallbackConfig")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<CallbackConfigInner>> getCallbackConfig(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry"
                + "/registries/{registryName}/webhooks/{webhookName}/listEvents")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EventListResult>> listEvents(
            @HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("registryName") String registryName,
            @PathParam("webhookName") String webhookName,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<WebhookListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EventListResult>> listEventsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            Context context);
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<WebhookInner>> getWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<WebhookInner>> getWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                context);
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WebhookInner> getAsync(String resourceGroupName, String registryName, String webhookName) {
        return getWithResponseAsync(resourceGroupName, registryName, webhookName)
            .flatMap(
                (Response<WebhookInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WebhookInner get(String resourceGroupName, String registryName, String webhookName) {
        return getAsync(resourceGroupName, registryName, webhookName).block();
    }

    /**
     * Gets the properties of the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<WebhookInner> getWithResponse(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        return getWithResponseAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookCreateParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null."));
        } else {
            webhookCreateParameters.validate();
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            webhookCreateParameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookCreateParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null."));
        } else {
            webhookCreateParameters.validate();
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                webhookCreateParameters,
                context);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<WebhookInner>, WebhookInner> beginCreateAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters);
        return this
            .client
            .<WebhookInner, WebhookInner>getLroResult(
                mono, this.client.getHttpPipeline(), WebhookInner.class, WebhookInner.class, Context.NONE);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<WebhookInner>, WebhookInner> beginCreateAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context);
        return this
            .client
            .<WebhookInner, WebhookInner>getLroResult(
                mono, this.client.getHttpPipeline(), WebhookInner.class, WebhookInner.class, context);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginCreate(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters) {
        return beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).getSyncPoller();
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginCreate(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters,
        Context context) {
        return beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context)
            .getSyncPoller();
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WebhookInner> createAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters) {
        return beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<WebhookInner> createAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters,
        Context context) {
        return beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WebhookInner create(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters) {
        return createAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).block();
    }

    /**
     * Creates a webhook for a container registry with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookCreateParameters The parameters for creating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WebhookInner create(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookCreateParameters webhookCreateParameters,
        Context context) {
        return createAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context).block();
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                context);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String registryName, String webhookName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, registryName, webhookName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, registryName, webhookName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String registryName, String webhookName) {
        return beginDeleteAsync(resourceGroupName, registryName, webhookName).getSyncPoller();
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        return beginDeleteAsync(resourceGroupName, registryName, webhookName, context).getSyncPoller();
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return beginDeleteAsync(resourceGroupName, registryName, webhookName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        return beginDeleteAsync(resourceGroupName, registryName, webhookName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String webhookName) {
        deleteAsync(resourceGroupName, registryName, webhookName).block();
    }

    /**
     * Deletes a webhook from a container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String webhookName, Context context) {
        deleteAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookUpdateParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null."));
        } else {
            webhookUpdateParameters.validate();
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            webhookUpdateParameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookUpdateParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null."));
        } else {
            webhookUpdateParameters.validate();
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                webhookUpdateParameters,
                context);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<WebhookInner>, WebhookInner> beginUpdateAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters);
        return this
            .client
            .<WebhookInner, WebhookInner>getLroResult(
                mono, this.client.getHttpPipeline(), WebhookInner.class, WebhookInner.class, Context.NONE);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<WebhookInner>, WebhookInner> beginUpdateAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context);
        return this
            .client
            .<WebhookInner, WebhookInner>getLroResult(
                mono, this.client.getHttpPipeline(), WebhookInner.class, WebhookInner.class, context);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginUpdate(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters) {
        return beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).getSyncPoller();
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginUpdate(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters,
        Context context) {
        return beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context)
            .getSyncPoller();
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<WebhookInner> updateAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters) {
        return beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<WebhookInner> updateAsync(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters,
        Context context) {
        return beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WebhookInner update(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters) {
        return updateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).block();
    }

    /**
     * Updates a webhook with the specified parameters.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param webhookUpdateParameters The parameters for updating a webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an object that represents a webhook for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public WebhookInner update(
        String resourceGroupName,
        String registryName,
        String webhookName,
        WebhookUpdateParameters webhookUpdateParameters,
        Context context) {
        return updateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context).block();
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebhookInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            context))
            .<PagedResponse<WebhookInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebhookInner>> listSinglePageAsync(
        String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<WebhookInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, registryName), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<WebhookInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, registryName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<WebhookInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable<>(listAsync(resourceGroupName, registryName));
    }

    /**
     * Lists all the webhooks for the specified container registry.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<WebhookInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, registryName, context));
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the basic information of an event.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<EventInfoInner>> pingWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .ping(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the basic information of an event.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<EventInfoInner>> pingWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .ping(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                context);
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the basic information of an event.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<EventInfoInner> pingAsync(String resourceGroupName, String registryName, String webhookName) {
        return pingWithResponseAsync(resourceGroupName, registryName, webhookName)
            .flatMap(
                (Response<EventInfoInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the basic information of an event.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EventInfoInner ping(String resourceGroupName, String registryName, String webhookName) {
        return pingAsync(resourceGroupName, registryName, webhookName).block();
    }

    /**
     * Triggers a ping event to be sent to the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the basic information of an event.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<EventInfoInner> pingWithResponse(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        return pingWithResponseAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configuration of service URI and custom headers for the webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CallbackConfigInner>> getCallbackConfigWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getCallbackConfig(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configuration of service URI and custom headers for the webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<CallbackConfigInner>> getCallbackConfigWithResponseAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .getCallbackConfig(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                context);
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configuration of service URI and custom headers for the webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CallbackConfigInner> getCallbackConfigAsync(
        String resourceGroupName, String registryName, String webhookName) {
        return getCallbackConfigWithResponseAsync(resourceGroupName, registryName, webhookName)
            .flatMap(
                (Response<CallbackConfigInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configuration of service URI and custom headers for the webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CallbackConfigInner getCallbackConfig(String resourceGroupName, String registryName, String webhookName) {
        return getCallbackConfigAsync(resourceGroupName, registryName, webhookName).block();
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configuration of service URI and custom headers for the webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CallbackConfigInner> getCallbackConfigWithResponse(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        return getCallbackConfigWithResponseAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EventInner>> listEventsSinglePageAsync(
        String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listEvents(
                            this.client.getEndpoint(),
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            registryName,
                            webhookName,
                            context))
            .<PagedResponse<EventInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EventInner>> listEventsSinglePageAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error(new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        final String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return service
            .listEvents(
                this.client.getEndpoint(),
                apiVersion,
                this.client.getSubscriptionId(),
                resourceGroupName,
                registryName,
                webhookName,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<EventInner> listEventsAsync(String resourceGroupName, String registryName, String webhookName) {
        return new PagedFlux<>(
            () -> listEventsSinglePageAsync(resourceGroupName, registryName, webhookName),
            nextLink -> listEventsNextSinglePageAsync(nextLink));
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<EventInner> listEventsAsync(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        return new PagedFlux<>(
            () -> listEventsSinglePageAsync(resourceGroupName, registryName, webhookName, context),
            nextLink -> listEventsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EventInner> listEvents(String resourceGroupName, String registryName, String webhookName) {
        return new PagedIterable<>(listEventsAsync(resourceGroupName, registryName, webhookName));
    }

    /**
     * Lists recent events for the specified webhook.
     *
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param registryName The name of the container registry.
     * @param webhookName The name of the webhook.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EventInner> listEvents(
        String resourceGroupName, String registryName, String webhookName, Context context) {
        return new PagedIterable<>(listEventsAsync(resourceGroupName, registryName, webhookName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebhookInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), context))
            .<PagedResponse<WebhookInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list webhooks for a container registry.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<WebhookInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EventInner>> listEventsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listEventsNext(nextLink, this.client.getEndpoint(), context))
            .<PagedResponse<EventInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of a request to list events for a webhook.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EventInner>> listEventsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listEventsNext(nextLink, this.client.getEndpoint(), context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
