// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The parameters for updating a container registry. */
@JsonFlatten
@Fluent
public class RegistryUpdateParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RegistryUpdateParameters.class);

    /*
     * The tags for the container registry.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /*
     * The SKU of the container registry.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /*
     * The value that indicates whether the admin user is enabled.
     */
    @JsonProperty(value = "properties.adminUserEnabled")
    private Boolean adminUserEnabled;

    /*
     * The network rule set for a container registry.
     */
    @JsonProperty(value = "properties.networkRuleSet")
    private NetworkRuleSet networkRuleSet;

    /*
     * The policies for a container registry.
     */
    @JsonProperty(value = "properties.policies")
    private Policies policies;

    /**
     * Get the tags property: The tags for the container registry.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags for the container registry.
     *
     * @param tags the tags value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the sku property: The SKU of the container registry.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU of the container registry.
     *
     * @param sku the sku value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     *
     * @return the adminUserEnabled value.
     */
    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    /**
     * Set the adminUserEnabled property: The value that indicates whether the admin user is enabled.
     *
     * @param adminUserEnabled the adminUserEnabled value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    /**
     * Get the networkRuleSet property: The network rule set for a container registry.
     *
     * @return the networkRuleSet value.
     */
    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    /**
     * Set the networkRuleSet property: The network rule set for a container registry.
     *
     * @param networkRuleSet the networkRuleSet value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    /**
     * Get the policies property: The policies for a container registry.
     *
     * @return the policies value.
     */
    public Policies policies() {
        return this.policies;
    }

    /**
     * Set the policies property: The policies for a container registry.
     *
     * @param policies the policies value to set.
     * @return the RegistryUpdateParameters object itself.
     */
    public RegistryUpdateParameters withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (networkRuleSet() != null) {
            networkRuleSet().validate();
        }
        if (policies() != null) {
            policies().validate();
        }
    }
}
