/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.SecretObject;
import java.io.IOException;

public final class CustomRegistryCredentials
implements JsonSerializable<CustomRegistryCredentials> {
    private SecretObject username;
    private SecretObject password;
    private String identity;

    public SecretObject username() {
        return this.username;
    }

    public CustomRegistryCredentials withUsername(SecretObject username) {
        this.username = username;
        return this;
    }

    public SecretObject password() {
        return this.password;
    }

    public CustomRegistryCredentials withPassword(SecretObject password) {
        this.password = password;
        return this;
    }

    public String identity() {
        return this.identity;
    }

    public CustomRegistryCredentials withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.username() != null) {
            this.username().validate();
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("userName", (JsonSerializable)this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static CustomRegistryCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (CustomRegistryCredentials)jsonReader.readObject(reader -> {
            CustomRegistryCredentials deserializedCustomRegistryCredentials = new CustomRegistryCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedCustomRegistryCredentials.username = SecretObject.fromJson(reader);
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCustomRegistryCredentials.password = SecretObject.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedCustomRegistryCredentials.identity = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomRegistryCredentials;
        });
    }
}

