/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.Argument;
import com.azure.resourcemanager.containerregistry.models.StepType;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import java.io.IOException;
import java.util.List;

public final class DockerBuildStepUpdateParameters
extends TaskStepUpdateParameters {
    private StepType type = StepType.DOCKER;
    private List<String> imageNames;
    private Boolean isPushEnabled;
    private Boolean noCache;
    private String dockerFilePath;
    private List<Argument> arguments;
    private String target;

    @Override
    public StepType type() {
        return this.type;
    }

    public List<String> imageNames() {
        return this.imageNames;
    }

    public DockerBuildStepUpdateParameters withImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        return this;
    }

    public Boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    public DockerBuildStepUpdateParameters withIsPushEnabled(Boolean isPushEnabled) {
        this.isPushEnabled = isPushEnabled;
        return this;
    }

    public Boolean noCache() {
        return this.noCache;
    }

    public DockerBuildStepUpdateParameters withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    public String dockerFilePath() {
        return this.dockerFilePath;
    }

    public DockerBuildStepUpdateParameters withDockerFilePath(String dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        return this;
    }

    public List<Argument> arguments() {
        return this.arguments;
    }

    public DockerBuildStepUpdateParameters withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String target() {
        return this.target;
    }

    public DockerBuildStepUpdateParameters withTarget(String target) {
        this.target = target;
        return this;
    }

    @Override
    public DockerBuildStepUpdateParameters withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public DockerBuildStepUpdateParameters withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.arguments() != null) {
            this.arguments().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath());
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("imageNames", this.imageNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isPushEnabled", this.isPushEnabled);
        jsonWriter.writeBooleanField("noCache", this.noCache);
        jsonWriter.writeStringField("dockerFilePath", this.dockerFilePath);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    public static DockerBuildStepUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DockerBuildStepUpdateParameters)jsonReader.readObject(reader -> {
            DockerBuildStepUpdateParameters deserializedDockerBuildStepUpdateParameters = new DockerBuildStepUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contextPath".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.withContextPath(reader.getString());
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.withContextAccessToken(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("imageNames".equals(fieldName)) {
                    List imageNames;
                    deserializedDockerBuildStepUpdateParameters.imageNames = imageNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isPushEnabled".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.isPushEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("noCache".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.noCache = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dockerFilePath".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.dockerFilePath = reader.getString();
                    continue;
                }
                if ("arguments".equals(fieldName)) {
                    List arguments;
                    deserializedDockerBuildStepUpdateParameters.arguments = arguments = reader.readArray(reader1 -> Argument.fromJson(reader1));
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedDockerBuildStepUpdateParameters.target = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDockerBuildStepUpdateParameters;
        });
    }
}

