// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import java.io.IOException;
import java.util.Map;

/**
 * An object that represents a replication for a container registry.
 */
@Fluent
public final class ReplicationInner extends Resource {
    /*
     * The properties of the replication.
     */
    private ReplicationProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ReplicationInner class.
     */
    public ReplicationInner() {
    }

    /**
     * Get the innerProperties property: The properties of the replication.
     * 
     * @return the innerProperties value.
     */
    private ReplicationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ReplicationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ReplicationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the replication at the time the operation was
     * called.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the status property: The status of the replication at the time the operation was called.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     * 
     * @return the regionEndpointEnabled value.
     */
    public Boolean regionEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().regionEndpointEnabled();
    }

    /**
     * Set the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     * 
     * @param regionEndpointEnabled the regionEndpointEnabled value to set.
     * @return the ReplicationInner object itself.
     */
    public ReplicationInner withRegionEndpointEnabled(Boolean regionEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicationProperties();
        }
        this.innerProperties().withRegionEndpointEnabled(regionEndpointEnabled);
        return this;
    }

    /**
     * Get the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry
     * replication.
     * 
     * @return the zoneRedundancy value.
     */
    public ZoneRedundancy zoneRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundancy();
    }

    /**
     * Set the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry
     * replication.
     * 
     * @param zoneRedundancy the zoneRedundancy value to set.
     * @return the ReplicationInner object itself.
     */
    public ReplicationInner withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicationProperties();
        }
        this.innerProperties().withZoneRedundancy(zoneRedundancy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReplicationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReplicationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReplicationInner.
     */
    public static ReplicationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReplicationInner deserializedReplicationInner = new ReplicationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedReplicationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedReplicationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedReplicationInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedReplicationInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedReplicationInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedReplicationInner.innerProperties = ReplicationProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedReplicationInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReplicationInner;
        });
    }
}
