// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The update parameters for scope map properties.
 */
@Fluent
public final class ScopeMapPropertiesUpdateParameters implements JsonSerializable<ScopeMapPropertiesUpdateParameters> {
    /*
     * The user friendly description of the scope map.
     */
    private String description;

    /*
     * The list of scope permissions for registry artifacts.
     * E.g. repositories/repository-name/pull,
     * repositories/repository-name/delete
     */
    private List<String> actions;

    /**
     * Creates an instance of ScopeMapPropertiesUpdateParameters class.
     */
    public ScopeMapPropertiesUpdateParameters() {
    }

    /**
     * Get the description property: The user friendly description of the scope map.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The user friendly description of the scope map.
     * 
     * @param description the description value to set.
     * @return the ScopeMapPropertiesUpdateParameters object itself.
     */
    public ScopeMapPropertiesUpdateParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actions property: The list of scope permissions for registry artifacts.
     * E.g. repositories/repository-name/pull,
     * repositories/repository-name/delete.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The list of scope permissions for registry artifacts.
     * E.g. repositories/repository-name/pull,
     * repositories/repository-name/delete.
     * 
     * @param actions the actions value to set.
     * @return the ScopeMapPropertiesUpdateParameters object itself.
     */
    public ScopeMapPropertiesUpdateParameters withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopeMapPropertiesUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopeMapPropertiesUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScopeMapPropertiesUpdateParameters.
     */
    public static ScopeMapPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopeMapPropertiesUpdateParameters deserializedScopeMapPropertiesUpdateParameters
                = new ScopeMapPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedScopeMapPropertiesUpdateParameters.description = reader.getString();
                } else if ("actions".equals(fieldName)) {
                    List<String> actions = reader.readArray(reader1 -> reader1.getString());
                    deserializedScopeMapPropertiesUpdateParameters.actions = actions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopeMapPropertiesUpdateParameters;
        });
    }
}
