// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.CacheRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of a request to list cache rules for a container registry.
 */
@Fluent
public final class CacheRulesListResult implements JsonSerializable<CacheRulesListResult> {
    /*
     * The list of cache rules.
     */
    private List<CacheRuleInner> value;

    /*
     * If provided, client must use NextLink URI to request next list of cache rules.
     */
    private String nextLink;

    /**
     * Creates an instance of CacheRulesListResult class.
     */
    public CacheRulesListResult() {
    }

    /**
     * Get the value property: The list of cache rules.
     * 
     * @return the value value.
     */
    public List<CacheRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of cache rules.
     * 
     * @param value the value value to set.
     * @return the CacheRulesListResult object itself.
     */
    public CacheRulesListResult withValue(List<CacheRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: If provided, client must use NextLink URI to request next list of cache rules.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: If provided, client must use NextLink URI to request next list of cache rules.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CacheRulesListResult object itself.
     */
    public CacheRulesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CacheRulesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CacheRulesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CacheRulesListResult.
     */
    public static CacheRulesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CacheRulesListResult deserializedCacheRulesListResult = new CacheRulesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CacheRuleInner> value = reader.readArray(reader1 -> CacheRuleInner.fromJson(reader1));
                    deserializedCacheRulesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCacheRulesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCacheRulesListResult;
        });
    }
}
