// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The current connection state of the connected registry.
 */
public final class ConnectionState extends ExpandableStringEnum<ConnectionState> {
    /**
     * Static value Online for ConnectionState.
     */
    public static final ConnectionState ONLINE = fromString("Online");

    /**
     * Static value Offline for ConnectionState.
     */
    public static final ConnectionState OFFLINE = fromString("Offline");

    /**
     * Static value Syncing for ConnectionState.
     */
    public static final ConnectionState SYNCING = fromString("Syncing");

    /**
     * Static value Unhealthy for ConnectionState.
     */
    public static final ConnectionState UNHEALTHY = fromString("Unhealthy");

    /**
     * Creates a new instance of ConnectionState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConnectionState() {
    }

    /**
     * Creates or finds a ConnectionState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConnectionState.
     */
    public static ConnectionState fromString(String name) {
        return fromString(name, ConnectionState.class);
    }

    /**
     * Gets known ConnectionState values.
     * 
     * @return known ConnectionState values.
     */
    public static Collection<ConnectionState> values() {
        return values(ConnectionState.class);
    }
}
