// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The Docker build step.
 */
@Fluent
public final class DockerTaskStep extends TaskStepProperties {
    /*
     * The type of the step.
     */
    private StepType type = StepType.DOCKER;

    /*
     * The fully qualified image names including the repository and tag.
     */
    private List<String> imageNames;

    /*
     * The value of this property indicates whether the image built should be pushed to the registry or not.
     */
    private Boolean isPushEnabled;

    /*
     * The value of this property indicates whether the image cache is enabled or not.
     */
    private Boolean noCache;

    /*
     * The Docker file path relative to the source context.
     */
    private String dockerFilePath;

    /*
     * The name of the target build stage for the docker build.
     */
    private String target;

    /*
     * The collection of override arguments to be used when executing this build step.
     */
    private List<Argument> arguments;

    /**
     * Creates an instance of DockerTaskStep class.
     */
    public DockerTaskStep() {
    }

    /**
     * Get the type property: The type of the step.
     * 
     * @return the type value.
     */
    @Override
    public StepType type() {
        return this.type;
    }

    /**
     * Get the imageNames property: The fully qualified image names including the repository and tag.
     * 
     * @return the imageNames value.
     */
    public List<String> imageNames() {
        return this.imageNames;
    }

    /**
     * Set the imageNames property: The fully qualified image names including the repository and tag.
     * 
     * @param imageNames the imageNames value to set.
     * @return the DockerTaskStep object itself.
     */
    public DockerTaskStep withImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        return this;
    }

    /**
     * Get the isPushEnabled property: The value of this property indicates whether the image built should be pushed to
     * the registry or not.
     * 
     * @return the isPushEnabled value.
     */
    public Boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    /**
     * Set the isPushEnabled property: The value of this property indicates whether the image built should be pushed to
     * the registry or not.
     * 
     * @param isPushEnabled the isPushEnabled value to set.
     * @return the DockerTaskStep object itself.
     */
    public DockerTaskStep withIsPushEnabled(Boolean isPushEnabled) {
        this.isPushEnabled = isPushEnabled;
        return this;
    }

    /**
     * Get the noCache property: The value of this property indicates whether the image cache is enabled or not.
     * 
     * @return the noCache value.
     */
    public Boolean noCache() {
        return this.noCache;
    }

    /**
     * Set the noCache property: The value of this property indicates whether the image cache is enabled or not.
     * 
     * @param noCache the noCache value to set.
     * @return the DockerTaskStep object itself.
     */
    public DockerTaskStep withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    /**
     * Get the dockerFilePath property: The Docker file path relative to the source context.
     * 
     * @return the dockerFilePath value.
     */
    public String dockerFilePath() {
        return this.dockerFilePath;
    }

    /**
     * Set the dockerFilePath property: The Docker file path relative to the source context.
     * 
     * @param dockerFilePath the dockerFilePath value to set.
     * @return the DockerTaskStep object itself.
     */
    public DockerTaskStep withDockerFilePath(String dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        return this;
    }

    /**
     * Get the target property: The name of the target build stage for the docker build.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The name of the target build stage for the docker build.
     * 
     * @param target the target value to set.
     * @return the DockerTaskStep object itself.
     */
    public DockerTaskStep withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the arguments property: The collection of override arguments to be used when executing this build step.
     * 
     * @return the arguments value.
     */
    public List<Argument> arguments() {
        return this.arguments;
    }

    /**
     * Set the arguments property: The collection of override arguments to be used when executing this build step.
     * 
     * @param arguments the arguments value to set.
     * @return the DockerTaskStep object itself.
     */
    public DockerTaskStep withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DockerTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DockerTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (dockerFilePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property dockerFilePath in model DockerTaskStep"));
        }
        if (arguments() != null) {
            arguments().forEach(e -> e.validate());
        }
        if (baseImageDependencies() != null) {
            baseImageDependencies().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DockerTaskStep.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", contextPath());
        jsonWriter.writeStringField("contextAccessToken", contextAccessToken());
        jsonWriter.writeStringField("dockerFilePath", this.dockerFilePath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("imageNames", this.imageNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isPushEnabled", this.isPushEnabled);
        jsonWriter.writeBooleanField("noCache", this.noCache);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("arguments", this.arguments, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DockerTaskStep from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DockerTaskStep if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DockerTaskStep.
     */
    public static DockerTaskStep fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DockerTaskStep deserializedDockerTaskStep = new DockerTaskStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseImageDependencies".equals(fieldName)) {
                    List<BaseImageDependency> baseImageDependencies
                        = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    deserializedDockerTaskStep.withBaseImageDependencies(baseImageDependencies);
                } else if ("contextPath".equals(fieldName)) {
                    deserializedDockerTaskStep.withContextPath(reader.getString());
                } else if ("contextAccessToken".equals(fieldName)) {
                    deserializedDockerTaskStep.withContextAccessToken(reader.getString());
                } else if ("dockerFilePath".equals(fieldName)) {
                    deserializedDockerTaskStep.dockerFilePath = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDockerTaskStep.type = StepType.fromString(reader.getString());
                } else if ("imageNames".equals(fieldName)) {
                    List<String> imageNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedDockerTaskStep.imageNames = imageNames;
                } else if ("isPushEnabled".equals(fieldName)) {
                    deserializedDockerTaskStep.isPushEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("noCache".equals(fieldName)) {
                    deserializedDockerTaskStep.noCache = reader.getNullable(JsonReader::getBoolean);
                } else if ("target".equals(fieldName)) {
                    deserializedDockerTaskStep.target = reader.getString();
                } else if ("arguments".equals(fieldName)) {
                    List<Argument> arguments = reader.readArray(reader1 -> Argument.fromJson(reader1));
                    deserializedDockerTaskStep.arguments = arguments;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDockerTaskStep;
        });
    }
}
