// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The event response message received from the service URI.
 */
@Fluent
public final class EventResponseMessage implements JsonSerializable<EventResponseMessage> {
    /*
     * The content of the event response message.
     */
    private String content;

    /*
     * The headers of the event response message.
     */
    private Map<String, String> headers;

    /*
     * The reason phrase of the event response message.
     */
    private String reasonPhrase;

    /*
     * The status code of the event response message.
     */
    private String statusCode;

    /*
     * The HTTP message version.
     */
    private String version;

    /**
     * Creates an instance of EventResponseMessage class.
     */
    public EventResponseMessage() {
    }

    /**
     * Get the content property: The content of the event response message.
     * 
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of the event response message.
     * 
     * @param content the content value to set.
     * @return the EventResponseMessage object itself.
     */
    public EventResponseMessage withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the headers property: The headers of the event response message.
     * 
     * @return the headers value.
     */
    public Map<String, String> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: The headers of the event response message.
     * 
     * @param headers the headers value to set.
     * @return the EventResponseMessage object itself.
     */
    public EventResponseMessage withHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the reasonPhrase property: The reason phrase of the event response message.
     * 
     * @return the reasonPhrase value.
     */
    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    /**
     * Set the reasonPhrase property: The reason phrase of the event response message.
     * 
     * @param reasonPhrase the reasonPhrase value to set.
     * @return the EventResponseMessage object itself.
     */
    public EventResponseMessage withReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    /**
     * Get the statusCode property: The status code of the event response message.
     * 
     * @return the statusCode value.
     */
    public String statusCode() {
        return this.statusCode;
    }

    /**
     * Set the statusCode property: The status code of the event response message.
     * 
     * @param statusCode the statusCode value to set.
     * @return the EventResponseMessage object itself.
     */
    public EventResponseMessage withStatusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Get the version property: The HTTP message version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The HTTP message version.
     * 
     * @param version the version value to set.
     * @return the EventResponseMessage object itself.
     */
    public EventResponseMessage withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("reasonPhrase", this.reasonPhrase);
        jsonWriter.writeStringField("statusCode", this.statusCode);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventResponseMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventResponseMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventResponseMessage.
     */
    public static EventResponseMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventResponseMessage deserializedEventResponseMessage = new EventResponseMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    deserializedEventResponseMessage.content = reader.getString();
                } else if ("headers".equals(fieldName)) {
                    Map<String, String> headers = reader.readMap(reader1 -> reader1.getString());
                    deserializedEventResponseMessage.headers = headers;
                } else if ("reasonPhrase".equals(fieldName)) {
                    deserializedEventResponseMessage.reasonPhrase = reader.getString();
                } else if ("statusCode".equals(fieldName)) {
                    deserializedEventResponseMessage.statusCode = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedEventResponseMessage.version = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEventResponseMessage;
        });
    }
}
