// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of the connected registry parent.
 */
@Fluent
public final class ParentProperties implements JsonSerializable<ParentProperties> {
    /*
     * The resource ID of the parent to which the connected registry will be associated.
     */
    private String id;

    /*
     * The sync properties of the connected registry with its parent.
     */
    private SyncProperties syncProperties;

    /**
     * Creates an instance of ParentProperties class.
     */
    public ParentProperties() {
    }

    /**
     * Get the id property: The resource ID of the parent to which the connected registry will be associated.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The resource ID of the parent to which the connected registry will be associated.
     * 
     * @param id the id value to set.
     * @return the ParentProperties object itself.
     */
    public ParentProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the syncProperties property: The sync properties of the connected registry with its parent.
     * 
     * @return the syncProperties value.
     */
    public SyncProperties syncProperties() {
        return this.syncProperties;
    }

    /**
     * Set the syncProperties property: The sync properties of the connected registry with its parent.
     * 
     * @param syncProperties the syncProperties value to set.
     * @return the ParentProperties object itself.
     */
    public ParentProperties withSyncProperties(SyncProperties syncProperties) {
        this.syncProperties = syncProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (syncProperties() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property syncProperties in model ParentProperties"));
        } else {
            syncProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ParentProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("syncProperties", this.syncProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ParentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ParentProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ParentProperties.
     */
    public static ParentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ParentProperties deserializedParentProperties = new ParentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("syncProperties".equals(fieldName)) {
                    deserializedParentProperties.syncProperties = SyncProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedParentProperties.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedParentProperties;
        });
    }
}
