// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The activation status of the connected registry.
 */
public final class ActivationStatus extends ExpandableStringEnum<ActivationStatus> {
    /**
     * Static value Active for ActivationStatus.
     */
    public static final ActivationStatus ACTIVE = fromString("Active");

    /**
     * Static value Inactive for ActivationStatus.
     */
    public static final ActivationStatus INACTIVE = fromString("Inactive");

    /**
     * Creates a new instance of ActivationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ActivationStatus() {
    }

    /**
     * Creates or finds a ActivationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ActivationStatus.
     */
    public static ActivationStatus fromString(String name) {
        return fromString(name, ActivationStatus.class);
    }

    /**
     * Gets known ActivationStatus values.
     * 
     * @return known ActivationStatus values.
     */
    public static Collection<ActivationStatus> values() {
        return values(ActivationStatus.class);
    }
}
