// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The trigger based on base image dependency.
 */
@Fluent
public final class BaseImageTrigger implements JsonSerializable<BaseImageTrigger> {
    /*
     * The type of the auto trigger for base image dependency updates.
     */
    private BaseImageTriggerType baseImageTriggerType;

    /*
     * The endpoint URL for receiving update triggers.
     */
    private String updateTriggerEndpoint;

    /*
     * Type of Payload body for Base image update triggers.
     */
    private UpdateTriggerPayloadType updateTriggerPayloadType;

    /*
     * The current status of trigger.
     */
    private TriggerStatus status;

    /*
     * The name of the trigger.
     */
    private String name;

    /**
     * Creates an instance of BaseImageTrigger class.
     */
    public BaseImageTrigger() {
    }

    /**
     * Get the baseImageTriggerType property: The type of the auto trigger for base image dependency updates.
     * 
     * @return the baseImageTriggerType value.
     */
    public BaseImageTriggerType baseImageTriggerType() {
        return this.baseImageTriggerType;
    }

    /**
     * Set the baseImageTriggerType property: The type of the auto trigger for base image dependency updates.
     * 
     * @param baseImageTriggerType the baseImageTriggerType value to set.
     * @return the BaseImageTrigger object itself.
     */
    public BaseImageTrigger withBaseImageTriggerType(BaseImageTriggerType baseImageTriggerType) {
        this.baseImageTriggerType = baseImageTriggerType;
        return this;
    }

    /**
     * Get the updateTriggerEndpoint property: The endpoint URL for receiving update triggers.
     * 
     * @return the updateTriggerEndpoint value.
     */
    public String updateTriggerEndpoint() {
        return this.updateTriggerEndpoint;
    }

    /**
     * Set the updateTriggerEndpoint property: The endpoint URL for receiving update triggers.
     * 
     * @param updateTriggerEndpoint the updateTriggerEndpoint value to set.
     * @return the BaseImageTrigger object itself.
     */
    public BaseImageTrigger withUpdateTriggerEndpoint(String updateTriggerEndpoint) {
        this.updateTriggerEndpoint = updateTriggerEndpoint;
        return this;
    }

    /**
     * Get the updateTriggerPayloadType property: Type of Payload body for Base image update triggers.
     * 
     * @return the updateTriggerPayloadType value.
     */
    public UpdateTriggerPayloadType updateTriggerPayloadType() {
        return this.updateTriggerPayloadType;
    }

    /**
     * Set the updateTriggerPayloadType property: Type of Payload body for Base image update triggers.
     * 
     * @param updateTriggerPayloadType the updateTriggerPayloadType value to set.
     * @return the BaseImageTrigger object itself.
     */
    public BaseImageTrigger withUpdateTriggerPayloadType(UpdateTriggerPayloadType updateTriggerPayloadType) {
        this.updateTriggerPayloadType = updateTriggerPayloadType;
        return this;
    }

    /**
     * Get the status property: The current status of trigger.
     * 
     * @return the status value.
     */
    public TriggerStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The current status of trigger.
     * 
     * @param status the status value to set.
     * @return the BaseImageTrigger object itself.
     */
    public BaseImageTrigger withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the name property: The name of the trigger.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the trigger.
     * 
     * @param name the name value to set.
     * @return the BaseImageTrigger object itself.
     */
    public BaseImageTrigger withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (baseImageTriggerType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property baseImageTriggerType in model BaseImageTrigger"));
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model BaseImageTrigger"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BaseImageTrigger.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("baseImageTriggerType",
            this.baseImageTriggerType == null ? null : this.baseImageTriggerType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("updateTriggerEndpoint", this.updateTriggerEndpoint);
        jsonWriter.writeStringField("updateTriggerPayloadType",
            this.updateTriggerPayloadType == null ? null : this.updateTriggerPayloadType.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BaseImageTrigger from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BaseImageTrigger if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BaseImageTrigger.
     */
    public static BaseImageTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BaseImageTrigger deserializedBaseImageTrigger = new BaseImageTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseImageTriggerType".equals(fieldName)) {
                    deserializedBaseImageTrigger.baseImageTriggerType
                        = BaseImageTriggerType.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedBaseImageTrigger.name = reader.getString();
                } else if ("updateTriggerEndpoint".equals(fieldName)) {
                    deserializedBaseImageTrigger.updateTriggerEndpoint = reader.getString();
                } else if ("updateTriggerPayloadType".equals(fieldName)) {
                    deserializedBaseImageTrigger.updateTriggerPayloadType
                        = UpdateTriggerPayloadType.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedBaseImageTrigger.status = TriggerStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBaseImageTrigger;
        });
    }
}
