// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ConnectedRegistryUpdateProperties;
import java.io.IOException;
import java.util.List;

/**
 * The parameters for updating a connected registry.
 */
@Fluent
public final class ConnectedRegistryUpdateParameters implements JsonSerializable<ConnectedRegistryUpdateParameters> {
    /*
     * The properties of the connected registry update parameters.
     */
    private ConnectedRegistryUpdateProperties innerProperties;

    /**
     * Creates an instance of ConnectedRegistryUpdateParameters class.
     */
    public ConnectedRegistryUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The properties of the connected registry update parameters.
     * 
     * @return the innerProperties value.
     */
    private ConnectedRegistryUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the syncProperties property: The sync properties of the connected registry with its parent.
     * 
     * @return the syncProperties value.
     */
    public SyncUpdateProperties syncProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().syncProperties();
    }

    /**
     * Set the syncProperties property: The sync properties of the connected registry with its parent.
     * 
     * @param syncProperties the syncProperties value to set.
     * @return the ConnectedRegistryUpdateParameters object itself.
     */
    public ConnectedRegistryUpdateParameters withSyncProperties(SyncUpdateProperties syncProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryUpdateProperties();
        }
        this.innerProperties().withSyncProperties(syncProperties);
        return this;
    }

    /**
     * Get the logging property: The logging properties of the connected registry.
     * 
     * @return the logging value.
     */
    public LoggingProperties logging() {
        return this.innerProperties() == null ? null : this.innerProperties().logging();
    }

    /**
     * Set the logging property: The logging properties of the connected registry.
     * 
     * @param logging the logging value to set.
     * @return the ConnectedRegistryUpdateParameters object itself.
     */
    public ConnectedRegistryUpdateParameters withLogging(LoggingProperties logging) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryUpdateProperties();
        }
        this.innerProperties().withLogging(logging);
        return this;
    }

    /**
     * Get the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @return the clientTokenIds value.
     */
    public List<String> clientTokenIds() {
        return this.innerProperties() == null ? null : this.innerProperties().clientTokenIds();
    }

    /**
     * Set the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @param clientTokenIds the clientTokenIds value to set.
     * @return the ConnectedRegistryUpdateParameters object itself.
     */
    public ConnectedRegistryUpdateParameters withClientTokenIds(List<String> clientTokenIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryUpdateProperties();
        }
        this.innerProperties().withClientTokenIds(clientTokenIds);
        return this;
    }

    /**
     * Get the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @return the notificationsList value.
     */
    public List<String> notificationsList() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationsList();
    }

    /**
     * Set the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @param notificationsList the notificationsList value to set.
     * @return the ConnectedRegistryUpdateParameters object itself.
     */
    public ConnectedRegistryUpdateParameters withNotificationsList(List<String> notificationsList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryUpdateProperties();
        }
        this.innerProperties().withNotificationsList(notificationsList);
        return this;
    }

    /**
     * Get the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @return the garbageCollection value.
     */
    public GarbageCollectionProperties garbageCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().garbageCollection();
    }

    /**
     * Set the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @param garbageCollection the garbageCollection value to set.
     * @return the ConnectedRegistryUpdateParameters object itself.
     */
    public ConnectedRegistryUpdateParameters withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryUpdateProperties();
        }
        this.innerProperties().withGarbageCollection(garbageCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedRegistryUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedRegistryUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectedRegistryUpdateParameters.
     */
    public static ConnectedRegistryUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedRegistryUpdateParameters deserializedConnectedRegistryUpdateParameters
                = new ConnectedRegistryUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateParameters.innerProperties
                        = ConnectedRegistryUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedRegistryUpdateParameters;
        });
    }
}
