// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TLS certificate properties of the connected registry login server.
 */
@Immutable
public final class TlsCertificateProperties implements JsonSerializable<TlsCertificateProperties> {
    /*
     * The type of certificate location.
     */
    private CertificateType type;

    /*
     * Indicates the location of the certificates.
     */
    private String location;

    /**
     * Creates an instance of TlsCertificateProperties class.
     */
    public TlsCertificateProperties() {
    }

    /**
     * Get the type property: The type of certificate location.
     * 
     * @return the type value.
     */
    public CertificateType type() {
        return this.type;
    }

    /**
     * Get the location property: Indicates the location of the certificates.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TlsCertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TlsCertificateProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TlsCertificateProperties.
     */
    public static TlsCertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TlsCertificateProperties deserializedTlsCertificateProperties = new TlsCertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedTlsCertificateProperties.type = CertificateType.fromString(reader.getString());
                } else if ("location".equals(fieldName)) {
                    deserializedTlsCertificateProperties.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTlsCertificateProperties;
        });
    }
}
