/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.BaseImageDependencyType;
import java.io.IOException;

public final class BaseImageDependency
implements JsonSerializable<BaseImageDependency> {
    private BaseImageDependencyType type;
    private String registry;
    private String repository;
    private String tag;
    private String digest;

    public BaseImageDependencyType type() {
        return this.type;
    }

    public BaseImageDependency withType(BaseImageDependencyType type) {
        this.type = type;
        return this;
    }

    public String registry() {
        return this.registry;
    }

    public BaseImageDependency withRegistry(String registry) {
        this.registry = registry;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public BaseImageDependency withRepository(String repository) {
        this.repository = repository;
        return this;
    }

    public String tag() {
        return this.tag;
    }

    public BaseImageDependency withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public String digest() {
        return this.digest;
    }

    public BaseImageDependency withDigest(String digest) {
        this.digest = digest;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("registry", this.registry);
        jsonWriter.writeStringField("repository", this.repository);
        jsonWriter.writeStringField("tag", this.tag);
        jsonWriter.writeStringField("digest", this.digest);
        return jsonWriter.writeEndObject();
    }

    public static BaseImageDependency fromJson(JsonReader jsonReader) throws IOException {
        return (BaseImageDependency)jsonReader.readObject(reader -> {
            BaseImageDependency deserializedBaseImageDependency = new BaseImageDependency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedBaseImageDependency.type = BaseImageDependencyType.fromString(reader.getString());
                    continue;
                }
                if ("registry".equals(fieldName)) {
                    deserializedBaseImageDependency.registry = reader.getString();
                    continue;
                }
                if ("repository".equals(fieldName)) {
                    deserializedBaseImageDependency.repository = reader.getString();
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    deserializedBaseImageDependency.tag = reader.getString();
                    continue;
                }
                if ("digest".equals(fieldName)) {
                    deserializedBaseImageDependency.digest = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBaseImageDependency;
        });
    }
}

